/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;

public final class Change {
    private final String id;
    private final Status status;
    private final Date submittedAt;

    private Change(String id, Status status, Date submittedAt) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.status = Preconditions.checkNotNull(status, "status for %s", (Object)id);
        this.submittedAt = Preconditions.checkNotNull(submittedAt, "submittedAt for %s", (Object)id);
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getSubmittedAt() {
        return this.submittedAt;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Change that = (Change)Change.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("status", (Object)this.status).add("submittedAt", this.submittedAt).toString();
    }

    public static Change create(String id, Status status, Date submittedAt) {
        return new Change(id, status, submittedAt);
    }

    public static enum Status {
        PENDING,
        INSYNC,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

