/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;

public class ParseMetadata
extends ParseJson<Metadata> {
    @Inject
    public ParseMetadata(Json json, TypeLiteral<Metadata> type) {
        super(json, type);
    }

    @Override
    public Metadata apply(HttpResponse response) {
        Map clbMetadata;
        try {
            Type clbMetadataType = new TypeLiteral<Map<String, List<CLBMetadata>>>(){}.getType();
            clbMetadata = (Map)this.apply(response.getPayload().getInput(), clbMetadataType);
        }
        catch (IOException e) {
            StringBuilder message = new StringBuilder();
            message.append("Error parsing response");
            this.logger.error(e, message.toString(), new Object[0]);
            throw new HttpResponseException(message.toString() + "\n" + response, null, response, (Throwable)e);
        }
        finally {
            HttpUtils.releasePayload(response);
        }
        return ParseMetadata.transformCLBMetadataToMetadata((List)clbMetadata.get("metadata"));
    }

    public static Metadata transformCLBMetadataToMetadata(List<CLBMetadata> clbMetadatum) {
        Metadata metadata = new Metadata();
        for (CLBMetadata clbMetadata : clbMetadatum) {
            metadata.put(clbMetadata.key, clbMetadata.value);
            metadata.putId(clbMetadata.key, clbMetadata.id);
        }
        return metadata;
    }

    public static class CLBMetadata {
        private int id;
        private String key;
        private String value;
    }
}

