/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public final class Protocol {
    private final String name;
    private final int port;

    @ConstructorProperties(value={"name", "port"})
    protected Protocol(String name, int port) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.port = port;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Protocol that = (Protocol)Protocol.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.port, that.port);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("port", this.port).toString();
    }
}

