/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.functions.ParseDomain;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecord;

public class ParseJob
implements Function<HttpResponse, Job<?>> {
    private final ParseJson<RawJob> parseJson;
    private final Json json;
    private boolean isCreateSingleRecord;
    private static final Function<ParseDomain.RawDomain, Domain> toDomain = new Function<ParseDomain.RawDomain, Domain>(){

        @Override
        public Domain apply(ParseDomain.RawDomain domain) {
            return domain.getDomain();
        }
    };

    @Inject
    ParseJob(Json json, ParseJson<RawJob> parseJson) {
        this.json = Preconditions.checkNotNull(json, "json");
        this.parseJson = Preconditions.checkNotNull(parseJson, "parseJson");
    }

    @Override
    public Job<?> apply(HttpResponse response) {
        RawJob rawJob = this.parseJson.apply(response);
        if (rawJob == null) {
            return null;
        }
        return this.toJob(rawJob);
    }

    public Job<?> toJob(RawJob in) {
        return Job.builder().id(in.jobId).status(in.status).error(in.error).resource(this.parseResponse(in.requestUrl, in.response)).build();
    }

    protected Object parseResponse(String requestUrl, JsonBall response) {
        if (response == null) {
            return null;
        }
        if (requestUrl.contains("import")) {
            Type type = new TypeLiteral<Map<String, Set<ParseDomain.RawDomain>>>(){}.getType();
            Map domainMap = (Map)this.json.fromJson(response.toString(), type);
            Domain domain = ((ParseDomain.RawDomain)Iterators.getOnlyElement(((Set)domainMap.get("domains")).iterator())).getDomain();
            return domain;
        }
        if (requestUrl.contains("export")) {
            Type type = new TypeLiteral<Map<String, String>>(){}.getType();
            Map exportMap = (Map)this.json.fromJson(response.toString(), type);
            String contents = (String)exportMap.get("contents");
            ArrayList<String> contentsAsList = Lists.newArrayList(Splitter.on("\n").omitEmptyStrings().split(contents));
            return contentsAsList;
        }
        if (response.toString().contains("domains")) {
            Type type = new TypeLiteral<Map<String, Set<ParseDomain.RawDomain>>>(){}.getType();
            Map domainMap = (Map)this.json.fromJson(response.toString(), type);
            ImmutableSet<Domain> domains = FluentIterable.from((Iterable)domainMap.get("domains")).transform(toDomain).toSet();
            return domains;
        }
        if (response.toString().contains("records")) {
            Type type = new TypeLiteral<Map<String, Set<ParseRecord.RawRecord>>>(){}.getType();
            Map recordMap = (Map)this.json.fromJson(response.toString(), type);
            ImmutableSet<RecordDetail> records = FluentIterable.from((Iterable)recordMap.get("records")).transform(ParseRecord.toRecordDetails).toSet();
            if (this.isCreateSingleRecord) {
                return Iterables.getOnlyElement(records);
            }
            return records;
        }
        throw new IllegalStateException("Job parsing problem. Did not recognize any type in job response.\n" + response.toString());
    }

    private static class RawJob {
        private String jobId;
        private Job.Status status;
        private Job.Error error;
        private String requestUrl;
        private JsonBall response;

        private RawJob() {
        }
    }
}

