/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

public class DomainChange {
    private final Date from;
    private final Date to;
    private final List<Change> changes;

    @ConstructorProperties(value={"from", "to", "changes"})
    private DomainChange(Date from, Date to, List<Change> changes) {
        this.from = from;
        this.to = to;
        this.changes = changes;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public int hashCode() {
        return Objects.hashCode(this.from, this.to, this.changes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DomainChange that = (DomainChange)DomainChange.class.cast(obj);
        return Objects.equal(this.from, that.from) && Objects.equal(this.to, that.to) && Objects.equal(this.changes, that.changes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("from", this.from).add("to", this.to).add("changes", this.changes).toString();
    }

    public static class ChangeDetail {
        private final String field;
        private final String originalValue;
        private final String newValue;

        @ConstructorProperties(value={"field", "originalValue", "newValue"})
        protected ChangeDetail(String field, String originalValue, String newValue) {
            this.field = field;
            this.originalValue = originalValue;
            this.newValue = newValue;
        }

        public String getField() {
            return this.field;
        }

        public String getOriginalValue() {
            return this.originalValue;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public int hashCode() {
            return Objects.hashCode(this.field, this.originalValue, this.newValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ChangeDetail that = (ChangeDetail)ChangeDetail.class.cast(obj);
            return Objects.equal(this.field, that.field) && Objects.equal(this.originalValue, that.originalValue) && Objects.equal(this.newValue, that.newValue);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("field", this.field).add("originalValue", this.originalValue).add("newValue", this.newValue).toString();
        }
    }

    public static class Change {
        private final String domain;
        private final String action;
        private final String targetType;
        private final int accountId;
        private final int targetId;
        private final List<ChangeDetail> changeDetails;

        @ConstructorProperties(value={"domain", "action", "targetType", "accountId", "targetId", "changeDetails"})
        protected Change(String domain, String action, String targetType, int accountId, int targetId, List<ChangeDetail> changeDetails) {
            this.domain = domain;
            this.action = action;
            this.targetType = targetType;
            this.accountId = accountId;
            this.targetId = targetId;
            this.changeDetails = changeDetails;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getAction() {
            return this.action;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public int getAccountId() {
            return this.accountId;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public List<ChangeDetail> getChangeDetails() {
            return this.changeDetails;
        }

        public int hashCode() {
            return Objects.hashCode(this.domain, this.action, this.targetType, this.accountId, this.targetId, this.changeDetails);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Change that = (Change)Change.class.cast(obj);
            return Objects.equal(this.domain, that.domain) && Objects.equal(this.action, that.action) && Objects.equal(this.targetType, that.targetType) && Objects.equal(this.accountId, that.accountId) && Objects.equal(this.targetId, that.targetId) && Objects.equal(this.changeDetails, that.changeDetails);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("domain", this.domain).add("action", this.action).add("targetType", this.targetType).add("accountId", this.accountId).add("targetId", this.targetId).add("changeDetails", this.changeDetails).toString();
        }
    }
}

