/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.binders;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;

public class FormatAndContentsToJSON
implements MapBinder {
    private static final String template = "{\"domains\":[{\"contentType\":\"%s\",\"contents\":\"%s\"}]}";

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        String format = postParams.get("format").toString();
        List contents = (List)List.class.cast(postParams.get("contents"));
        return (R)((HttpRequest.Builder)request.toBuilder().payload(this.toJSON(format, contents))).build();
    }

    private String toJSON(String format, List<String> contents) {
        String contentsAsOneString = Joiner.on("\\n").join(contents);
        return String.format(template, format, contentsAsOneString);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

