/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.binder.firewall;

import com.google.common.base.Strings;
import java.util.List;
import org.jclouds.profitbricks.binder.BaseProfitBricksRequestBinder;

public abstract class FirewallBinder
extends BaseProfitBricksRequestBinder<List<String>> {
    protected final StringBuilder requestBuilder = new StringBuilder(128);

    FirewallBinder() {
        super("ids");
    }

    protected void bindListWithTag(List<String> ids, String tag) {
        if (ids == null || ids.isEmpty() || Strings.isNullOrEmpty(tag)) {
            return;
        }
        for (String id : ids) {
            this.requestBuilder.append(String.format("<%s>%s</%s>", tag, id, tag));
        }
    }

    public static class RemoveFirewallRuleRequestBinder
    extends FirewallBinder {
        @Override
        protected String createPayload(List<String> payload) {
            this.requestBuilder.append("<ws:removeFirewallRules>");
            this.bindListWithTag(payload, "firewallRuleIds");
            this.requestBuilder.append("</ws:removeFirewallRules>");
            return this.requestBuilder.toString();
        }
    }

    public static class DeleteFirewallRequestBinder
    extends FirewallBinder {
        @Override
        protected String createPayload(List<String> payload) {
            this.requestBuilder.append("<ws:deleteFirewalls>");
            this.bindListWithTag(payload, "firewallIds");
            this.requestBuilder.append("</ws:deleteFirewalls>");
            return this.requestBuilder.toString();
        }
    }

    public static class DeactivateFirewallRequestBinder
    extends FirewallBinder {
        @Override
        protected String createPayload(List<String> payload) {
            this.requestBuilder.append("<ws:deactivateFirewalls>");
            this.bindListWithTag(payload, "firewallIds");
            this.requestBuilder.append("</ws:deactivateFirewalls>");
            return this.requestBuilder.toString();
        }
    }

    public static class ActivateFirewallRequestBinder
    extends FirewallBinder {
        @Override
        protected String createPayload(List<String> payload) {
            this.requestBuilder.append("<ws:activateFirewalls>");
            this.bindListWithTag(payload, "firewallIds");
            this.requestBuilder.append("</ws:activateFirewalls>");
            return this.requestBuilder.toString();
        }
    }
}

