/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.trove.v1.domain.Instance;
import org.jclouds.openstack.trove.v1.features.InstanceApi;
import org.jclouds.util.Predicates2;

public class InstancePredicates {
    public static Predicate<Instance> awaitAvailable(InstanceApi instanceApi) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(instanceApi, Instance.Status.ACTIVE);
        return Predicates2.retry(statusPredicate, 600L, 5L, 5L, TimeUnit.SECONDS);
    }

    public static Predicate<Instance> awaitDeleted(InstanceApi instanceApi) {
        DeletedPredicate deletedPredicate = new DeletedPredicate(instanceApi);
        return Predicates2.retry(deletedPredicate, 600L, 5L, 5L, TimeUnit.SECONDS);
    }

    public static Predicate<Instance> awaitStatus(InstanceApi instanceApi, Instance.Status status, long maxWaitInSec, long periodInSec) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(instanceApi, status);
        return Predicates2.retry(statusPredicate, maxWaitInSec, periodInSec, periodInSec, TimeUnit.SECONDS);
    }

    private static class DeletedPredicate
    implements Predicate<Instance> {
        private InstanceApi instanceApi;

        public DeletedPredicate(InstanceApi instanceApi) {
            this.instanceApi = Preconditions.checkNotNull(instanceApi, "instanceApi must be defined");
        }

        @Override
        public boolean apply(Instance instance) {
            Preconditions.checkNotNull(instance, "instance must be defined");
            return this.instanceApi.get(instance.getId()) == null;
        }
    }

    private static class StatusUpdatedPredicate
    implements Predicate<Instance> {
        private InstanceApi instanceApi;
        private Instance.Status status;

        public StatusUpdatedPredicate(InstanceApi instanceApi, Instance.Status status) {
            this.instanceApi = Preconditions.checkNotNull(instanceApi, "instanceApi must be defined");
            this.status = Preconditions.checkNotNull(status, "status must be defined");
        }

        @Override
        public boolean apply(Instance instance) {
            Preconditions.checkNotNull(instance, "instance must be defined");
            if (this.status.equals((Object)instance.getStatus())) {
                return true;
            }
            Instance instanceUpdated = this.instanceApi.get(instance.getId());
            Preconditions.checkNotNull(instanceUpdated, "Instance %s not found.", (Object)instance.getId());
            return this.status.equals((Object)instanceUpdated.getStatus());
        }
    }
}

