/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.openstack.v2_0.domain.Link;

public class Flavor
implements Comparable<Flavor> {
    private final int id;
    private final Optional<String> name;
    private final int ram;
    private final List<Link> links;

    @ConstructorProperties(value={"id", "name", "ram", "links"})
    protected Flavor(int id, String name, int ram, List<Link> links) {
        this.id = id;
        this.name = Optional.fromNullable(name);
        this.ram = ram;
        this.links = links;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name.orNull();
    }

    public int getRam() {
        return this.ram;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Flavor that = (Flavor)Flavor.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("ram", this.ram);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Flavor that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getId() > that.getId() ? 1 : (this.getId() < that.getId() ? -1 : 0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromFlavor(this);
    }

    public static class Builder {
        protected int id;
        protected String name;
        protected int ram;
        protected List<Link> links;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ram(int ram) {
            this.ram = ram;
            return this;
        }

        public Builder links(List<Link> links) {
            this.links = ImmutableList.copyOf(links);
            return this;
        }

        public Flavor build() {
            return new Flavor(this.id, this.name, this.ram, this.links);
        }

        public Builder fromFlavor(Flavor in) {
            return this.id(in.getId()).name(in.getName()).ram(in.getRam()).links(in.getLinks());
        }
    }
}

