/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.Context;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.internal.BaseView;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.rest.Utils;

public class RegionScopedBlobStoreContext
extends BaseView
implements BlobStoreContext {
    private final Supplier<Set<String>> regionIds;
    private final Supplier<String> implicitRegionId;
    private final Function<String, BlobStore> blobStore;
    private final Function<String, BlobRequestSigner> blobRequestSigner;
    private final Utils utils;
    private final ConsistencyModel consistencyModel;

    public Set<String> getConfiguredRegions() {
        return this.regionIds.get();
    }

    public BlobStore getBlobStore(String regionId) {
        this.checkRegionId(regionId);
        return this.blobStore.apply(regionId);
    }

    public BlobRequestSigner getSigner(String regionId) {
        this.checkRegionId(regionId);
        return this.blobRequestSigner.apply(regionId);
    }

    protected void checkRegionId(String regionId) {
        Preconditions.checkArgument(this.getConfiguredRegions().contains(Preconditions.checkNotNull(regionId, "regionId was null")), "region %s not in %s", (Object)regionId, this.getConfiguredRegions());
    }

    @Inject
    public RegionScopedBlobStoreContext(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, @Region Supplier<Set<String>> regionIds, @Region Supplier<String> implicitRegionId, Function<String, BlobStore> blobStore, Function<String, BlobRequestSigner> blobRequestSigner, Utils utils, ConsistencyModel consistencyModel) {
        super(backend, backendType);
        this.regionIds = Preconditions.checkNotNull(regionIds, "regionIds");
        this.implicitRegionId = Preconditions.checkNotNull(implicitRegionId, "implicitRegionId");
        this.blobStore = Preconditions.checkNotNull(blobStore, "blobStore");
        this.blobRequestSigner = Preconditions.checkNotNull(blobRequestSigner, "blobRequestSigner");
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.consistencyModel = Preconditions.checkNotNull(consistencyModel, "consistencyModel");
    }

    @Override
    public ConsistencyModel getConsistencyModel() {
        return this.consistencyModel;
    }

    @Override
    public BlobStore getBlobStore() {
        return this.getBlobStore(this.implicitRegionId.get());
    }

    @Override
    public BlobRequestSigner getSigner() {
        return this.getSigner(this.implicitRegionId.get());
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public void close() {
        this.delegate().close();
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

