/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.binders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class TempAuthBinder
implements Binder {
    private final String identityHeaderNameUser;
    private final String identityHeaderNamePass;

    @Inject
    TempAuthBinder(@Named(value="jclouds.swift.tempAuth.headerUser") String identityHeaderNameUser, @Named(value="jclouds.swift.tempAuth.headerPass") String identityHeaderNamePass) {
        this.identityHeaderNameUser = identityHeaderNameUser;
        this.identityHeaderNamePass = identityHeaderNamePass;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull(request, "request");
        Preconditions.checkArgument(input instanceof Credentials, "input must be a non-null org.jclouds.domain.Credentials");
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().replaceHeader(this.identityHeaderNameUser, ((Credentials)input).identity)).replaceHeader(this.identityHeaderNamePass, ((Credentials)input).credential)).build();
    }
}

