/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.openstack.nova.v2_0.domain.BlockDeviceMapping;
import org.jclouds.openstack.nova.v2_0.domain.Network;
import org.jclouds.scriptbuilder.domain.Statement;

public class NovaTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected boolean autoAssignFloatingIp = false;
    protected Optional<Set<String>> floatingIpPoolNames = Optional.absent();
    protected boolean generateKeyPair = false;
    protected String keyPairName;
    protected byte[] userData;
    protected String diskConfig;
    protected boolean configDrive;
    protected Set<Network> novaNetworks;
    protected String availabilityZone;
    protected Set<BlockDeviceMapping> blockDeviceMappings = ImmutableSet.of();

    @Override
    public NovaTemplateOptions clone() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof NovaTemplateOptions) {
            NovaTemplateOptions eTo = (NovaTemplateOptions)NovaTemplateOptions.class.cast(to);
            eTo.autoAssignFloatingIp(this.shouldAutoAssignFloatingIp());
            if (this.getFloatingIpPoolNames().isPresent()) {
                eTo.floatingIpPoolNames((Iterable<String>)this.getFloatingIpPoolNames().get());
            }
            eTo.generateKeyPair(this.shouldGenerateKeyPair());
            eTo.keyPairName(this.getKeyPairName());
            if (this.getUserData() != null) {
                eTo.userData(this.getUserData());
            }
            if (this.getDiskConfig() != null) {
                eTo.diskConfig(this.getDiskConfig());
            }
            eTo.configDrive(this.getConfigDrive());
            eTo.novaNetworks(this.getNovaNetworks());
            eTo.availabilityZone(this.getAvailabilityZone());
            eTo.blockDeviceMappings(this.getBlockDeviceMappings());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NovaTemplateOptions that = (NovaTemplateOptions)NovaTemplateOptions.class.cast(o);
        return super.equals(that) && Objects.equal(this.autoAssignFloatingIp, that.autoAssignFloatingIp) && Objects.equal(this.floatingIpPoolNames, that.floatingIpPoolNames) && Objects.equal(this.generateKeyPair, that.generateKeyPair) && Objects.equal(this.keyPairName, that.keyPairName) && Arrays.equals(this.userData, that.userData) && Objects.equal(this.diskConfig, that.diskConfig) && Objects.equal(this.configDrive, that.configDrive) && Objects.equal(this.novaNetworks, that.novaNetworks) && Objects.equal(this.availabilityZone, that.availabilityZone) && Objects.equal(this.blockDeviceMappings, that.blockDeviceMappings);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.autoAssignFloatingIp, this.floatingIpPoolNames, this.generateKeyPair, this.keyPairName, Arrays.hashCode(this.userData), this.diskConfig, this.configDrive, this.novaNetworks, this.availabilityZone, this.blockDeviceMappings);
    }

    @Override
    public MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = super.string();
        if (!this.autoAssignFloatingIp) {
            toString.add("autoAssignFloatingIp", this.autoAssignFloatingIp);
        }
        if (this.floatingIpPoolNames.isPresent()) {
            toString.add("floatingIpPoolNames", this.floatingIpPoolNames.get());
        }
        if (this.generateKeyPair) {
            toString.add("generateKeyPair", this.generateKeyPair);
        }
        toString.add("keyPairName", this.keyPairName);
        toString.add("userData", this.userData);
        toString.add("diskConfig", this.diskConfig);
        toString.add("configDrive", this.configDrive);
        toString.add("novaNetworks", this.novaNetworks);
        toString.add("availabilityZone", this.availabilityZone);
        toString.add("blockDeviceMappings", this.blockDeviceMappings);
        return toString;
    }

    public NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
        this.autoAssignFloatingIp = enable;
        return this;
    }

    public NovaTemplateOptions floatingIpPoolNames(String ... floatingIpPoolNames) {
        return this.floatingIpPoolNames(ImmutableSet.copyOf(Preconditions.checkNotNull(floatingIpPoolNames, "floatingIpPoolNames")));
    }

    public NovaTemplateOptions floatingIpPoolNames(Iterable<String> floatingIpPoolNames) {
        for (String groupName : Preconditions.checkNotNull(floatingIpPoolNames, "floatingIpPoolNames")) {
            Preconditions.checkNotNull(Strings.emptyToNull(groupName), "all floating-ip-pool-names must be non-empty");
        }
        this.floatingIpPoolNames = Optional.of(ImmutableSet.copyOf(floatingIpPoolNames));
        return this;
    }

    public NovaTemplateOptions generateKeyPair(boolean enable) {
        this.generateKeyPair = enable;
        return this;
    }

    public NovaTemplateOptions keyPairName(String keyPairName) {
        this.keyPairName = keyPairName;
        return this;
    }

    public boolean shouldAutoAssignFloatingIp() {
        return this.autoAssignFloatingIp;
    }

    public NovaTemplateOptions availabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public NovaTemplateOptions blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        return this.blockDeviceMappings(ImmutableSet.copyOf(Preconditions.checkNotNull(blockDeviceMappings, "blockDeviceMappings")));
    }

    public NovaTemplateOptions blockDeviceMappings(Iterable<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = ImmutableSet.copyOf(blockDeviceMappings);
        return this;
    }

    public Optional<Set<String>> getFloatingIpPoolNames() {
        return this.floatingIpPoolNames;
    }

    public String getKeyPairName() {
        return this.keyPairName;
    }

    public boolean shouldGenerateKeyPair() {
        return this.generateKeyPair;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public String getDiskConfig() {
        return this.diskConfig;
    }

    public boolean getConfigDrive() {
        return this.configDrive;
    }

    public Set<Network> getNovaNetworks() {
        return this.novaNetworks;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Set<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    @Override
    public NovaTemplateOptions blockOnPort(int port, int seconds) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public NovaTemplateOptions inboundPorts(int ... ports) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public NovaTemplateOptions authorizePublicKey(String publicKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public NovaTemplateOptions installPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    public NovaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    @Override
    public NovaTemplateOptions dontAuthorizePublicKey() {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    @Override
    public NovaTemplateOptions nameTask(String name) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public NovaTemplateOptions runAsRoot(boolean runAsRoot) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public NovaTemplateOptions runScript(Statement script) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    public NovaTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public NovaTemplateOptions overrideLoginPassword(String password) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public NovaTemplateOptions overrideLoginUser(String loginUser) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    @Override
    public NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    @Override
    public NovaTemplateOptions userMetadata(String key, String value) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    @Override
    public NovaTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    @Override
    public NovaTemplateOptions networks(Iterable<String> networks) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.networks(networks));
    }

    @Override
    public NovaTemplateOptions networks(String ... networks) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.networks(networks));
    }

    public NovaTemplateOptions userData(byte[] userData) {
        Preconditions.checkArgument(Preconditions.checkNotNull(userData, "userData").length <= 16384, "userData cannot be larger than 16kb");
        this.userData = userData;
        return this;
    }

    public NovaTemplateOptions diskConfig(String diskConfig) {
        this.diskConfig = diskConfig;
        return this;
    }

    public NovaTemplateOptions configDrive(boolean configDrive) {
        this.configDrive = configDrive;
        return this;
    }

    public NovaTemplateOptions novaNetworks(Set<Network> novaNetworks) {
        this.novaNetworks = novaNetworks;
        return this;
    }

    public static class Builder {
        public static NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
            return new NovaTemplateOptions().autoAssignFloatingIp(enable);
        }

        public NovaTemplateOptions floatingIpPoolNames(String ... floatingIpPoolNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.floatingIpPoolNames(floatingIpPoolNames));
        }

        public NovaTemplateOptions floatingIpPoolNames(Iterable<String> floatingIpPoolNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.floatingIpPoolNames(floatingIpPoolNames));
        }

        public static NovaTemplateOptions generateKeyPair(boolean enable) {
            return new NovaTemplateOptions().generateKeyPair(enable);
        }

        public static NovaTemplateOptions keyPairName(String keyPairName) {
            return new NovaTemplateOptions().keyPairName(keyPairName);
        }

        public static NovaTemplateOptions inboundPorts(int ... ports) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static NovaTemplateOptions blockOnPort(int port, int seconds) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static NovaTemplateOptions installPrivateKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static NovaTemplateOptions authorizePublicKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static NovaTemplateOptions nodeNames(Iterable<String> nodeNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static NovaTemplateOptions networks(Iterable<String> networks) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.networks((Iterable)networks));
        }

        public static NovaTemplateOptions overrideLoginUser(String user) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static NovaTemplateOptions overrideLoginPassword(String password) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static NovaTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static NovaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        public static NovaTemplateOptions userData(byte[] userData) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.userData(userData));
        }

        public static NovaTemplateOptions diskConfig(String diskConfig) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.diskConfig(diskConfig));
        }

        public static NovaTemplateOptions configDrive(boolean configDrive) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.configDrive(configDrive));
        }

        public static NovaTemplateOptions novaNetworks(Set<Network> novaNetworks) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.novaNetworks(novaNetworks));
        }

        public static NovaTemplateOptions availabilityZone(String availabilityZone) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.availabilityZone(availabilityZone);
        }
    }
}

