/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.Context;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.FloatingIP;
import org.jclouds.openstack.neutron.v2.domain.Network;
import org.jclouds.openstack.neutron.v2.domain.Networks;
import org.jclouds.openstack.neutron.v2.domain.Port;
import org.jclouds.openstack.neutron.v2.features.NetworkApi;
import org.jclouds.openstack.neutron.v2.features.PortApi;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.CleanupResources;
import org.jclouds.openstack.nova.v2_0.compute.options.NodeAndNovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIpForServer;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.rest.ApiContext;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

public class AllocateAndAddFloatingIpToNode
implements Function<AtomicReference<NodeAndNovaTemplateOptions>, AtomicReference<NodeMetadata>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="openstack-neutron")
    private Supplier<Context> neutronContextSupplier;
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    private final NovaApi novaApi;
    private final LoadingCache<RegionAndId, Iterable<? extends FloatingIpForServer>> floatingIpCache;
    private final CleanupResources cleanupResources;

    @Inject
    public AllocateAndAddFloatingIpToNode(@Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, NovaApi novaApi, @Named(value="FLOATINGIP") LoadingCache<RegionAndId, Iterable<? extends FloatingIpForServer>> floatingIpCache, CleanupResources cleanupResources) {
        this.nodeRunning = Preconditions.checkNotNull(nodeRunning, "nodeRunning");
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.floatingIpCache = Preconditions.checkNotNull(floatingIpCache, "floatingIpCache");
        this.cleanupResources = Preconditions.checkNotNull(cleanupResources, "cleanupResources");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public AtomicReference<NodeMetadata> apply(AtomicReference<NodeAndNovaTemplateOptions> input) {
        Preconditions.checkState(this.nodeRunning.apply(input.get().getNodeMetadata()), "node never achieved state running %s", input.get().getNodeMetadata());
        final NodeMetadata node = input.get().getNodeMetadata().get();
        String regionId = node.getLocation().getParent().getId();
        Optional<Set<String>> poolNames = input.get().getNovaTemplateOptions().get().getFloatingIpPoolNames();
        String availabilityZone = this.getAvailabilityZoneFromTemplateOptionsOrDefault(input, regionId);
        if (this.isNeutronLinked()) {
            org.jclouds.openstack.neutron.v2.features.FloatingIPApi neutronFloatingApi = this.getFloatingIPApi(regionId);
            Optional<Port> optionalPort = this.getPortApi(regionId).list().concat().firstMatch(new Predicate<Port>(){

                @Override
                public boolean apply(@Nullable Port input) {
                    return input.getDeviceId().equals(node.getProviderId());
                }
            });
            if (!optionalPort.isPresent()) {
                this.logger.error("Node %s doesn't have a port to attach a floating IP", node);
                throw new IllegalStateException("Missing required port in node: " + node);
            }
            Optional<org.jclouds.openstack.neutron.v2.domain.FloatingIP> floatingIPOptional = this.tryFindExistingFloatingIp(neutronFloatingApi, availabilityZone);
            org.jclouds.openstack.neutron.v2.domain.FloatingIP floatingIP = floatingIPOptional.isPresent() ? floatingIPOptional.get() : this.createFloatingIpUsingNeutron(neutronFloatingApi, node, poolNames, availabilityZone);
            org.jclouds.openstack.neutron.v2.domain.FloatingIP ip = neutronFloatingApi.update(floatingIP.getId(), ((FloatingIP.UpdateBuilder)FloatingIP.UpdateFloatingIP.updateBuilder().portId(optionalPort.get().getId())).build());
            input.get().getNodeMetadata().set(NodeMetadataBuilder.fromNodeMetadata(node).publicAddresses(ImmutableSet.of(ip.getFloatingIpAddress())).build());
            return input.get().getNodeMetadata();
        }
        FloatingIPApi floatingIpApi = this.novaApi.getFloatingIPApi(regionId).get();
        Optional<FloatingIP> ip = this.allocateFloatingIPForNodeOnNova(floatingIpApi, poolNames, node.getId());
        if (!ip.isPresent()) {
            this.cleanupResources.apply(node);
            throw new InsufficientResourcesException("Failed to allocate a FloatingIP for node(" + node.getId() + ")");
        }
        this.logger.debug(">> adding floatingIp(%s) to node(%s)", ip.get().getIp(), node.getId());
        floatingIpApi.addToServer(ip.get().getIp(), node.getProviderId());
        input.get().getNodeMetadata().set(NodeMetadataBuilder.fromNodeMetadata(node).publicAddresses(ImmutableSet.of(ip.get().getIp())).build());
        this.floatingIpCache.asMap().put(RegionAndId.fromSlashEncoded(node.getId()), ImmutableList.of(FloatingIpForServer.create(RegionAndId.fromSlashEncoded(node.getId()), ip.get().getId(), ip.get().getIp())));
        return input.get().getNodeMetadata();
    }

    private String getAvailabilityZoneFromTemplateOptionsOrDefault(AtomicReference<NodeAndNovaTemplateOptions> input, String regionId) {
        return MoreObjects.firstNonNull(input.get().getNovaTemplateOptions().get().getAvailabilityZone(), Iterables.get(this.novaApi.getAvailabilityZoneApi(regionId).get().listAvailabilityZones(), 0).getName());
    }

    private synchronized Optional<FloatingIP> allocateFloatingIPForNodeOnNova(FloatingIPApi floatingIpApi, Optional<Set<String>> poolNames, String nodeID) {
        if (poolNames.isPresent()) {
            for (String poolName : poolNames.get()) {
                try {
                    this.logger.debug(">> allocating floating IP from pool %s for node(%s)", poolName, nodeID);
                    FloatingIP ip = floatingIpApi.allocateFromPool(poolName);
                    return Optional.of(ip);
                }
                catch (ResourceNotFoundException ex) {
                    this.logger.trace("<< [%s] failed to allocate floating IP from pool %s for node(%s)", ex.getMessage(), poolName, nodeID);
                }
                catch (InsufficientResourcesException ire) {
                    this.logger.trace("<< [%s] failed to allocate floating IP from pool %s for node(%s)", ire.getMessage(), poolName, nodeID);
                }
            }
        }
        try {
            this.logger.debug(">> creating floating IP for node(%s)", nodeID);
            FloatingIP ip = floatingIpApi.create();
            return Optional.of(ip);
        }
        catch (ResourceNotFoundException ex) {
            this.logger.trace("<< [%s] failed to create floating IP for node(%s)", ex.getMessage(), nodeID);
        }
        catch (InsufficientResourcesException ire) {
            this.logger.trace("<< [%s] failed to create floating IP for node(%s)", ire.getMessage(), nodeID);
        }
        this.logger.trace(">> searching for existing, unassigned floating IP for node(%s)", nodeID);
        ArrayList<FloatingIP> unassignedIps = Lists.newArrayList(Iterables.filter(floatingIpApi.list(), new Predicate<FloatingIP>(){

            @Override
            public boolean apply(FloatingIP arg0) {
                return arg0.getFixedIp() == null;
            }
        }));
        if (unassignedIps.isEmpty()) {
            return Optional.absent();
        }
        Collections.shuffle(unassignedIps);
        FloatingIP ip = Iterables.getLast(unassignedIps);
        return Optional.fromNullable(ip);
    }

    private Optional<org.jclouds.openstack.neutron.v2.domain.FloatingIP> tryFindExistingFloatingIp(org.jclouds.openstack.neutron.v2.features.FloatingIPApi neutronFloatingApi, final String availabilityZone) {
        Optional<org.jclouds.openstack.neutron.v2.domain.FloatingIP> floatingIPOptional = neutronFloatingApi.list().concat().firstMatch(new Predicate<org.jclouds.openstack.neutron.v2.domain.FloatingIP>(){

            @Override
            public boolean apply(@Nullable org.jclouds.openstack.neutron.v2.domain.FloatingIP input) {
                return input.getPortId() == null && input.getAvailabilityZone().equals(availabilityZone);
            }
        });
        return floatingIPOptional;
    }

    private org.jclouds.openstack.neutron.v2.domain.FloatingIP createFloatingIpUsingNeutron(org.jclouds.openstack.neutron.v2.features.FloatingIPApi neutronFloatingApi, NodeMetadata node, Optional<Set<String>> poolNames, String availabilityZone) {
        String regionId = node.getLocation().getParent().getId();
        List<Network> networks = this.getSuitableNetworks(regionId, availabilityZone, poolNames.or(Sets.newHashSet()));
        org.jclouds.openstack.neutron.v2.domain.FloatingIP floatingIP = null;
        for (Network network : networks) {
            try {
                this.logger.debug(">> allocating floating IP from network %s for node(%s)", network, node);
                FloatingIP.CreateFloatingIP createFloatingIP = ((FloatingIP.CreateBuilder)FloatingIP.CreateFloatingIP.createBuilder(network.getId()).availabilityZone(network.getAvailabilityZone())).build();
                floatingIP = neutronFloatingApi.create(createFloatingIP);
                this.logger.debug(">> allocated floating IP(%s) from network(%s) for node(%s)", floatingIP, network, node);
                this.floatingIpCache.asMap().put(RegionAndId.fromSlashEncoded(node.getId()), ImmutableList.of(FloatingIpForServer.create(RegionAndId.fromSlashEncoded(node.getId()), floatingIP.getId(), floatingIP.getFloatingIpAddress())));
                return floatingIP;
            }
            catch (Exception ex) {
                this.logger.trace("<< [%s] failed to allocate a floating IP from network %s for node(%s)", ex.getMessage(), network, node);
            }
        }
        throw new IllegalStateException("Failed to allocate a floating IP for node " + node + ".\nFailed to find suitable external networks or to allocate from poolNames specified: " + Iterables.toString((Iterable)poolNames.get()));
    }

    private List<Network> getSuitableNetworks(String regionId, String availabilityZone, Set<String> poolNames) {
        ImmutableList<Network> allNetworks = this.getNetworkApi(regionId).list().concat().toList();
        Iterable<Network> externalNetworks = Iterables.filter(allNetworks, Networks.Predicates.externalNetworks(availabilityZone));
        Iterable<Network> networksFromPoolName = Iterables.filter(allNetworks, Networks.Predicates.namedNetworks(poolNames));
        return Lists.newArrayList(Iterables.concat(networksFromPoolName, externalNetworks));
    }

    private boolean isNeutronLinked() {
        return this.neutronContextSupplier != null && this.neutronContextSupplier.get() != null;
    }

    private org.jclouds.openstack.neutron.v2.features.FloatingIPApi getFloatingIPApi(String region) {
        return ((NeutronApi)((ApiContext)this.neutronContextSupplier.get()).getApi()).getFloatingIPApi(region);
    }

    private PortApi getPortApi(String regionId) {
        return ((NeutronApi)((ApiContext)this.neutronContextSupplier.get()).getApi()).getPortApi(regionId);
    }

    private NetworkApi getNetworkApi(String regionId) {
        return ((NeutronApi)((ApiContext)this.neutronContextSupplier.get()).getApi()).getNetworkApi(regionId);
    }

    public String toString() {
        return MoreObjects.toStringHelper("AllocateAndAddFloatingIpToNode").toString();
    }
}

