/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain.lbaas.v1;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.LBaaSStatus;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.Protocol;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.SessionPersistence;

public class VIP {
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="subnet_id")
    private String subnetId;
    private Protocol protocol;
    @Named(value="protocol_port")
    private Integer protocolPort;
    @Named(value="pool_id")
    private String poolId;
    private String address;
    private String name;
    private String description;
    @Named(value="session_persistence")
    private SessionPersistence sessionPersistence;
    @Named(value="connection_limit")
    private Integer connectionLimit;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    private String id;
    @Named(value="port_id")
    private String portId;
    private LBaaSStatus status;
    @Named(value="status_description")
    private String statusDescription;

    @ConstructorProperties(value={"id", "tenant_id", "name", "description", "subnet_id", "address", "port_id", "protocol", "protocol_port", "pool_id", "session_persistence", "connection_limit", "admin_state_up", "status", "status_description"})
    private VIP(String id, String tenantId, String name, String description, String subnetId, String address, String portId, Protocol protocol, Integer protocolPort, String poolId, SessionPersistence sessionPersistence, Integer connectionLimit, Boolean adminStateUp, LBaaSStatus status, String statusDescription) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.subnetId = subnetId;
        this.address = address;
        this.portId = portId;
        this.protocol = protocol;
        this.protocolPort = protocolPort;
        this.poolId = poolId;
        this.sessionPersistence = sessionPersistence;
        this.connectionLimit = connectionLimit;
        this.adminStateUp = adminStateUp;
        this.status = status;
        this.statusDescription = statusDescription;
    }

    private VIP() {
    }

    private VIP(VIP vip) {
        this(vip.id, vip.tenantId, vip.name, vip.description, vip.subnetId, vip.address, vip.portId, vip.protocol, vip.protocolPort, vip.poolId, vip.sessionPersistence, vip.connectionLimit, vip.adminStateUp, vip.status, vip.statusDescription);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getSubnetId() {
        return this.subnetId;
    }

    @Nullable
    public String getAddress() {
        return this.address;
    }

    @Nullable
    public String getPortId() {
        return this.portId;
    }

    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Nullable
    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    @Nullable
    public String getPoolId() {
        return this.poolId;
    }

    @Nullable
    public SessionPersistence getSessionPersistence() {
        return this.sessionPersistence;
    }

    @Nullable
    public Integer getConnectionLimit() {
        return this.connectionLimit;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public LBaaSStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getStatusDescription() {
        return this.statusDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VIP that = (VIP)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.subnetId, that.subnetId) && Objects.equal(this.address, that.address) && Objects.equal(this.portId, that.portId) && Objects.equal((Object)this.protocol, (Object)that.protocol) && Objects.equal(this.protocolPort, that.protocolPort) && Objects.equal(this.poolId, that.poolId) && Objects.equal(this.sessionPersistence, that.sessionPersistence) && Objects.equal(this.connectionLimit, that.connectionLimit) && Objects.equal(this.adminStateUp, that.adminStateUp) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.statusDescription, that.statusDescription);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.tenantId, this.name, this.description, this.subnetId, this.address, this.portId, this.protocol, this.protocolPort, this.poolId, this.sessionPersistence, this.connectionLimit, this.adminStateUp, this.status, this.statusDescription});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("name", this.name).add("description", this.description).add("subnetId", this.subnetId).add("address", this.address).add("portId", this.portId).add("protocol", (Object)this.protocol).add("protocolPort", this.protocolPort).add("poolId", this.poolId).add("sessionPersistence", this.sessionPersistence).add("connectionLimit", this.connectionLimit).add("adminStateUp", this.adminStateUp).add("status", (Object)this.status).add("statusDescription", this.statusDescription).toString();
    }

    public static CreateBuilder createBuilder(String subnetId, Protocol protocol, Integer port, String poolId) {
        return new CreateBuilder(subnetId, protocol, port, poolId);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class UpdateVIP
    extends VIP {
        private UpdateVIP(VIP vip) {
            super(vip);
        }
    }

    public static class CreateVIP
    extends VIP {
        private CreateVIP(VIP vip) {
            super(vip);
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateVIP build() {
            return new UpdateVIP(this.vip);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String subnetId, Protocol protocol, Integer port, String poolId) {
            this.subnetId(subnetId).protocol(protocol).protocolPort(port).poolId(poolId);
        }

        public CreateBuilder tenantId(String tenantId) {
            this.vip.tenantId = tenantId;
            return this.self();
        }

        public CreateBuilder subnetId(String subnetId) {
            this.vip.subnetId = subnetId;
            return this.self();
        }

        public CreateBuilder address(String address) {
            this.vip.address = address;
            return this.self();
        }

        public CreateBuilder protocol(Protocol protocol) {
            this.vip.protocol = protocol;
            return this.self();
        }

        public CreateBuilder protocolPort(Integer protocolPort) {
            this.vip.protocolPort = protocolPort;
            return this.self();
        }

        public CreateVIP build() {
            return new CreateVIP(this.vip);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected VIP vip = new VIP();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType name(String name) {
            this.vip.name = name;
            return this.self();
        }

        public ParameterizedBuilderType description(String description) {
            this.vip.description = description;
            return this.self();
        }

        public ParameterizedBuilderType poolId(String poolId) {
            this.vip.poolId = poolId;
            return this.self();
        }

        public ParameterizedBuilderType sessionPersistence(SessionPersistence sessionPersistence) {
            this.vip.sessionPersistence = sessionPersistence;
            return this.self();
        }

        public ParameterizedBuilderType connectionLimit(Integer connectionLimit) {
            this.vip.connectionLimit = connectionLimit;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.vip.adminStateUp = adminStateUp;
            return this.self();
        }
    }
}

