/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.binders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.v3.domain.Auth;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public abstract class BindAuthToJsonPayload<T>
extends BindToJsonPayload
implements MapBinder {
    private static final Set<String> SCOPE_PREFIXES = ImmutableSet.of("project", "projectId", "domain", "domainId");

    protected BindAuthToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    protected abstract Auth buildAuth(TenantOrDomainAndCredentials<T> var1, Object var2);

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Optional<Object> authentication = Iterables.tryFind(gRequest.getInvocation().getArgs(), Predicates.instanceOf(TenantOrDomainAndCredentials.class));
        Preconditions.checkArgument(authentication.isPresent(), "no credentials found in the api call arguments");
        TenantOrDomainAndCredentials credentials = (TenantOrDomainAndCredentials)authentication.get();
        Object scope = this.parseScope(credentials);
        Auth auth = this.buildAuth(credentials, scope);
        R authRequest = super.bindToRequest(request, ImmutableMap.of("auth", auth));
        authRequest.getPayload().setSensitive(true);
        return authRequest;
    }

    private Object parseScope(TenantOrDomainAndCredentials<T> credentials) {
        String scope = credentials.scope();
        if (!scope.contains(":")) {
            Preconditions.checkArgument(scope.equals("unscoped"), "Invalid scope: %s", (Object)scope);
            return "unscoped";
        }
        String[] parts = scope.split(":");
        Preconditions.checkArgument(parts.length == 2, "Invalid scope: %s", (Object)scope);
        Preconditions.checkArgument(SCOPE_PREFIXES.contains(parts[0]), "Scope prefix should be: %s", SCOPE_PREFIXES);
        if ("project".equals(parts[0])) {
            return Auth.ProjectScope.create(Auth.ProjectScope.ProjectName.create(parts[1], this.parseProjectDomain(credentials, true)));
        }
        if ("projectId".equals(parts[0])) {
            return Auth.ProjectIdScope.create(Auth.ProjectIdScope.ProjectId.create(parts[1], this.parseProjectDomain(credentials, false)));
        }
        if ("domain".equals(parts[0])) {
            return Auth.DomainScope.create(Auth.Name.create(parts[1]));
        }
        return Auth.DomainIdScope.create(Auth.Id.create(parts[1]));
    }

    private Object parseProjectDomain(TenantOrDomainAndCredentials<T> credentials, boolean useTenantAsDefaultDomain) {
        Object domainScope = null;
        if (useTenantAsDefaultDomain && credentials.tenantOrDomainId() != null) {
            domainScope = Auth.Id.create(credentials.tenantOrDomainId());
        } else if (credentials.projectDomainName() != null) {
            domainScope = Auth.Name.create(credentials.projectDomainName());
        } else if (credentials.projectDomainId() != null) {
            domainScope = Auth.Id.create(credentials.projectDomainId());
        } else if (useTenantAsDefaultDomain) {
            domainScope = Auth.Name.create(credentials.tenantOrDomainName());
        }
        return domainScope;
    }
}

