/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Tenant {
    private final String id;
    private final String name;
    private final String description;
    private final Boolean enabled;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTenant(this);
    }

    @ConstructorProperties(value={"id", "name", "description", "enabled"})
    protected Tenant(String id, String name, @Nullable String description, @Nullable Boolean enabled) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = description;
        this.enabled = enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tenant that = (Tenant)Tenant.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.enabled, that.enabled);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("description", this.description).add("enabled", this.enabled);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String description;
        protected Boolean enabled;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T enabled(Boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public Tenant build() {
            return new Tenant(this.id, this.name, this.description, this.enabled);
        }

        public T fromTenant(Tenant in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).description(in.getDescription());
        }
    }
}

