/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ohai.suppliers;

import com.google.common.base.Supplier;
import java.lang.management.RuntimeMXBean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.JsonBall;

@Singleton
public class UptimeSecondsSupplier
implements Supplier<JsonBall> {
    private final RuntimeMXBean runtime;

    @Inject
    UptimeSecondsSupplier(RuntimeMXBean runtime) {
        this.runtime = runtime;
    }

    @Override
    public JsonBall get() {
        long uptimeInSeconds = this.runtime.getUptime() / 1000L;
        return new JsonBall(uptimeInSeconds);
    }
}

