/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.binders.HttpHealthCheckCreationBinder;
import org.jclouds.googlecomputeengine.domain.HttpHealthCheck;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.HttpHealthCheckCreationOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/httpHealthChecks")
@Consumes(value={"application/json"})
public interface HttpHealthCheckApi {
    @Named(value="HttpHealthChecks:get")
    @GET
    @Path(value="/{httpHealthCheck}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HttpHealthCheck get(@PathParam(value="httpHealthCheck") String var1);

    @Named(value="HttpHealthChecks:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation insert(@PayloadParam(value="name") String var1);

    @Named(value="HttpHealthChecks:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=HttpHealthCheckCreationBinder.class)
    public Operation insert(@PayloadParam(value="name") String var1, @PayloadParam(value="options") HttpHealthCheckCreationOptions var2);

    @Named(value="HttpHealthChecks:delete")
    @DELETE
    @Path(value="/{httpHealthCheck}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="httpHealthCheck") String var1);

    @Named(value="HttpHealthChecks:patch")
    @PATCH
    @Path(value="/{httpHealthCheck}")
    @MapBinder(value=HttpHealthCheckCreationBinder.class)
    @Nullable
    public Operation patch(@PathParam(value="httpHealthCheck") @PayloadParam(value="name") String var1, @PayloadParam(value="options") HttpHealthCheckCreationOptions var2);

    @Named(value="HttpHealthChecks:update")
    @PUT
    @Path(value="/{httpHealthCheck}")
    @Produces(value={"application/json"})
    @MapBinder(value=HttpHealthCheckCreationBinder.class)
    public Operation update(@PathParam(value="httpHealthCheck") @PayloadParam(value="name") String var1, @PayloadParam(value="options") HttpHealthCheckCreationOptions var2);

    @Named(value="HttpHealthChecks:list")
    @GET
    public ListPage<HttpHealthCheck> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="HttpHealthChecks:list")
    @GET
    @Transform(value=HttpHealthCheckPages.class)
    public Iterator<ListPage<HttpHealthCheck>> list();

    @Named(value="HttpHealthChecks:list")
    @GET
    @Transform(value=HttpHealthCheckPages.class)
    public Iterator<ListPage<HttpHealthCheck>> list(ListOptions var1);

    public static final class HttpHealthCheckPages
    extends BaseToIteratorOfListPage<HttpHealthCheck, HttpHealthCheckPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        HttpHealthCheckPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<HttpHealthCheck>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<HttpHealthCheck>>(){

                @Override
                public ListPage<HttpHealthCheck> apply(String pageToken) {
                    return api.httpHeathChecks().listPage(pageToken, options);
                }
            };
        }
    }
}

