/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.parser;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.regex.Pattern;
import org.jclouds.googlecloudstorage.domain.ResumableUpload;
import org.jclouds.http.HttpResponse;

public class ParseToResumableUpload
implements Function<HttpResponse, ResumableUpload> {
    @Override
    public ResumableUpload apply(HttpResponse response) {
        String contentLength = response.getFirstHeaderOrNull("Content-Length");
        String sessionUri = response.getFirstHeaderOrNull("Location");
        String uploadId = null;
        if (sessionUri != null) {
            uploadId = this.getUploadId(sessionUri);
        }
        String range = response.getFirstHeaderOrNull("Range");
        Long upperLimit = null;
        Long lowerLimit = null;
        if (range != null) {
            upperLimit = this.getUpperLimitFromRange(range);
            lowerLimit = this.getLowerLimitFromRange(range);
            if (lowerLimit != null && upperLimit != null) {
                Preconditions.checkArgument(lowerLimit < upperLimit, "lower range must less than upper range, was: %s - %s", (Object)lowerLimit, (Object)upperLimit);
            }
        }
        return ResumableUpload.create(response.getStatusCode(), uploadId, contentLength, lowerLimit, upperLimit);
    }

    private String getUploadId(String sessionUri) {
        return Splitter.on(Pattern.compile("\\&")).trimResults().omitEmptyStrings().withKeyValueSeparator("=").split(sessionUri).get("upload_id");
    }

    private long getUpperLimitFromRange(String range) {
        String upperLimit = range.split("-")[1];
        return Long.parseLong(upperLimit);
    }

    private long getLowerLimitFromRange(String range) {
        String removeByte = range.split("=")[1];
        String lowerLimit = removeByte.split("-")[0];
        return Long.parseLong(lowerLimit);
    }
}

