/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.binders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.googlecloudstorage.domain.templates.ObjectTemplate;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.json.Json;
import org.jclouds.rest.MapBinder;

public final class MultipartUploadBinder
implements MapBinder {
    private static final String BOUNDARY_HEADER = "multipart_boundary";
    private final Json json;

    @Inject
    MultipartUploadBinder(Json json) {
        this.json = json;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ObjectTemplate template = (ObjectTemplate)postParams.get("template");
        Payload payload = (Payload)postParams.get("payload");
        String contentType = Preconditions.checkNotNull(template.contentType(), "contentType");
        Long length = Preconditions.checkNotNull(template.size(), "contentLength");
        StringPayload jsonPayload = Payloads.newStringPayload(this.json.toJson(template));
        payload.getContentMetadata().setContentLength(length);
        Part jsonPart = Part.create("Metadata", jsonPayload, new Part.PartOptions().contentType("application/json"));
        Part mediaPart = Part.create(template.name(), payload, new Part.PartOptions().contentType(contentType));
        request.resetPayload(false);
        request.setPayload(new MultipartForm(BOUNDARY_HEADER, jsonPart, mediaPart));
        ((HttpRequest.Builder)request.toBuilder().replaceHeader("Content-Type", "Multipart/related; boundary= multipart_boundary")).build();
        return request;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return request;
    }
}

