/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jclouds.io.Payload;
import org.jclouds.util.Closeables2;

public final class TreeHash {
    private static final int CHUNK_SIZE = 0x100000;
    private final HashCode treeHash;
    private final HashCode linearHash;

    private TreeHash(HashCode treeHash, HashCode linearHash) {
        this.treeHash = Preconditions.checkNotNull(treeHash, "treeHash");
        this.linearHash = Preconditions.checkNotNull(linearHash, "linearHash");
    }

    public HashCode getLinearHash() {
        return this.linearHash;
    }

    public HashCode getTreeHash() {
        return this.treeHash;
    }

    public int hashCode() {
        return Objects.hashCode(this.treeHash, this.linearHash);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeHash other = (TreeHash)obj;
        return Objects.equal(this.treeHash, other.treeHash) && Objects.equal(this.linearHash, other.linearHash);
    }

    public String toString() {
        return "TreeHash [treeHash=" + this.treeHash + ", linearHash=" + this.linearHash + "]";
    }

    private static HashCode hashList(Collection<HashCode> hashList) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (hashList.size() > 1) {
            Iterator<HashCode> it = hashList.iterator();
            while (it.hasNext()) {
                HashCode hc1 = it.next();
                if (it.hasNext()) {
                    HashCode hc2 = it.next();
                    result.add(Hashing.sha256().newHasher().putBytes(hc1.asBytes()).putBytes(hc2.asBytes()).hash());
                    continue;
                }
                result.add(hc1);
            }
            hashList = result.build();
            result = ImmutableList.builder();
        }
        return hashList.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeHash buildTreeHashFromPayload(Payload payload) throws IOException {
        TreeHash treeHash;
        InputStream is = null;
        try {
            HashingInputStream chunkedHis;
            long count;
            is = Preconditions.checkNotNull(payload, "payload").openStream();
            ImmutableList.Builder list = ImmutableList.builder();
            HashingInputStream linearHis = new HashingInputStream(Hashing.sha256(), is);
            while ((count = ByteStreams.copy(chunkedHis = new HashingInputStream(Hashing.sha256(), ByteStreams.limit(linearHis, 0x100000L)), ByteStreams.nullOutputStream())) != 0L) {
                list.add(chunkedHis.hash());
            }
            treeHash = new TreeHash(TreeHash.hashList(list.build()), linearHis.hash());
        }
        catch (Throwable throwable) {
            Closeables2.closeQuietly(is);
            throw throwable;
        }
        Closeables2.closeQuietly(is);
        return treeHash;
    }

    public static HashCode buildTreeHashFromMap(Map<Integer, HashCode> map) {
        Preconditions.checkArgument(!map.isEmpty(), "The map cannot be empty.");
        return TreeHash.hashList(ImmutableSortedMap.copyOf(map).values());
    }
}

