/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public final class ContentRange {
    private final long from;
    private final long to;

    private ContentRange(long from, long to) {
        Preconditions.checkArgument(from < to, "\"from\" should be lower than \"to\"");
        Preconditions.checkArgument(from >= 0L && to > 0L, "\"from\" cannot be negative and \"to\" has to be positive");
        this.from = from;
        this.to = to;
    }

    public static ContentRange fromString(String contentRangeString) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(contentRangeString) && contentRangeString.matches("[0-9]+-[0-9]+"), "The string should be two numbers separated by a hyphen (from-to)");
        String[] strings = contentRangeString.split("-", 2);
        long from = Long.parseLong(strings[0]);
        long to = Long.parseLong(strings[1]);
        return new ContentRange(from, to);
    }

    public static ContentRange fromPartNumber(long partNumber, long partSizeInMB) {
        Preconditions.checkArgument(partNumber >= 0L, "The part number cannot be negative");
        Preconditions.checkArgument(partSizeInMB > 0L, "The part size has to be positive");
        long from = partNumber * (partSizeInMB << 20);
        long to = from + (partSizeInMB << 20) - 1L;
        return new ContentRange(from, to);
    }

    public static ContentRange build(long from, long to) {
        return new ContentRange(from, to);
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public String buildHeader() {
        return "bytes " + this.from + "-" + this.to + "/*";
    }

    public int hashCode() {
        return Objects.hashCode(this.from, this.to);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentRange other = (ContentRange)obj;
        return Objects.equal(this.from, other.from) && Objects.equal(this.to, other.to);
    }

    public String toString() {
        return this.from + "-" + this.to;
    }
}

