/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.predicates.validators;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import org.jclouds.predicates.Validator;

@Singleton
public final class VaultNameValidator
extends Validator<String> {
    private static final int MIN_LENGTH = 1;
    private static final int MAX_LENGTH = 255;
    private static final CharMatcher VAULT_NAME_ACCEPTABLE_RANGE = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf("-_."));

    @Override
    public void validate(String vaultName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(vaultName) && vaultName.length() <= 255, "Can't be null or empty. Length must be %s to %s symbols.", 1, 255);
        Preconditions.checkArgument(VAULT_NAME_ACCEPTABLE_RANGE.matchesAllOf(vaultName), "Should contain only ASCII letters and numbers, underscores, hyphens, or periods.");
    }
}

