/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.handlers;

import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import org.jclouds.glacier.GlacierResponseException;
import org.jclouds.glacier.domain.GlacierError;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

public class ParseGlacierErrorFromJsonContent
extends ParseJson<GlacierError>
implements HttpErrorHandler {
    @Inject
    public ParseGlacierErrorFromJsonContent(Json json) {
        super(json, TypeLiteral.get(GlacierError.class));
    }

    private static Exception refineException(GlacierError error, Exception exception) {
        if ("AccessDeniedException".equals(error.getCode())) {
            return new AuthorizationException(error.getMessage(), exception);
        }
        if ("InvalidParameterValueException".equals(error.getCode())) {
            return new IllegalArgumentException(error.getMessage(), exception);
        }
        if ("LimitExceededException".equals(error.getCode())) {
            return new InsufficientResourcesException(error.getMessage(), exception);
        }
        if ("ResourceNotFoundException".equals(error.getCode())) {
            return new ResourceNotFoundException(error.getMessage(), exception);
        }
        return exception;
    }

    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        GlacierError error = (GlacierError)this.apply(response);
        HttpResponseException exception = error.isValid() ? ParseGlacierErrorFromJsonContent.refineException(error, new GlacierResponseException(command, response, error)) : new HttpResponseException(command, response);
        command.setException(exception);
    }
}

