/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.functions;

import com.google.common.base.Function;
import com.google.common.hash.HashCode;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;

public class ParseMultipartUploadTreeHashHeader
implements Function<HttpResponse, HashCode> {
    @Override
    public HashCode apply(HttpResponse from) {
        String treehash = from.getFirstHeaderOrNull("x-amz-sha256-tree-hash");
        if (treehash == null) {
            throw new HttpException("Did not receive Tree hash");
        }
        return HashCode.fromString(treehash);
    }
}

