/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.glacier.domain.ArchiveMetadata;
import org.jclouds.glacier.domain.ArchiveMetadataCollection;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public class ArchiveMetadataCollectionToStorageMetadata
implements Function<ArchiveMetadataCollection, PageSet<? extends StorageMetadata>> {
    @Override
    public PageSet<? extends StorageMetadata> apply(ArchiveMetadataCollection archives) {
        return new PageSetImpl<MutableBlobMetadata>(Iterables.transform(archives, new ArchiveMetadataToBlobMetadata()), null);
    }

    private static class ArchiveMetadataToBlobMetadata
    implements Function<ArchiveMetadata, MutableBlobMetadata> {
        private ArchiveMetadataToBlobMetadata() {
        }

        @Override
        public MutableBlobMetadata apply(ArchiveMetadata from) {
            BaseMutableContentMetadata contentMetadata = new BaseMutableContentMetadata();
            contentMetadata.setContentLength(from.getSize());
            MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
            to.setName(from.getArchiveId());
            to.setCreationDate(from.getCreationDate());
            to.setContentMetadata(contentMetadata);
            return to;
        }
    }
}

