/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.javax.annotation.Nullable;

public class WellKnownImage {
    public static final String DEFAULT_USER = "toor";
    private final String loginUser;
    private final String uuid;
    private final String description;
    private final OsFamily osFamily;
    private final String osVersion;
    private final int size;
    private final boolean is64bit;

    public static Builder builder() {
        return new Builder();
    }

    public WellKnownImage(@Nullable String loginUser, String uuid, String description, OsFamily osFamily, @Nullable String osVersion, int size, @Nullable Boolean is64bit) {
        this.loginUser = MoreObjects.firstNonNull(loginUser, DEFAULT_USER);
        this.uuid = Preconditions.checkNotNull(uuid, "uuid cannot be null");
        this.description = Preconditions.checkNotNull(description, "description cannot be null");
        this.osFamily = Preconditions.checkNotNull(osFamily, "osFamily cannot be null");
        this.osVersion = osVersion;
        this.size = size;
        this.is64bit = MoreObjects.firstNonNull(is64bit, Boolean.TRUE);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getDescription() {
        return this.description;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public int getSize() {
        return this.size;
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.uuid, this.description, this.osFamily, this.osVersion, this.size, this.is64bit, this.loginUser});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WellKnownImage)) {
            return false;
        }
        WellKnownImage that = (WellKnownImage)obj;
        return Objects.equal(this.loginUser, that.loginUser) && Objects.equal(this.uuid, that.uuid) && Objects.equal(this.description, that.description) && Objects.equal((Object)this.osFamily, (Object)that.osFamily) && Objects.equal(this.osVersion, that.osVersion) && Objects.equal(this.size, that.size) && Objects.equal(this.is64bit, that.is64bit);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("uuid", this.uuid).add("description", this.description).add("osFamily", (Object)this.osFamily).add("osVersion", this.osVersion).add("size", this.size).add("is64bit", this.is64bit).add("loginUser", this.loginUser).toString();
    }

    public static class Builder {
        private String loginUser;
        private String uuid;
        private String description;
        private OsFamily osFamily;
        private String osVersion;
        private int size;
        private boolean is64bit;

        public Builder loginUser(String loginUser) {
            this.loginUser = loginUser;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder is64bit(boolean is64bit) {
            this.is64bit = is64bit;
            return this;
        }

        public WellKnownImage build() {
            return new WellKnownImage(this.loginUser, this.uuid, this.description, this.osFamily, this.osVersion, this.size, this.is64bit);
        }
    }
}

