/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.logging.Logger;

@Singleton
public class ServerInfoToNodeMetadata
implements Function<ServerInfo, NodeMetadata> {
    public static final Map<ServerStatus, NodeMetadata.Status> serverStatusToNodeStatus = ImmutableMap.builder().put(ServerStatus.ACTIVE, NodeMetadata.Status.RUNNING).put(ServerStatus.STOPPED, NodeMetadata.Status.SUSPENDED).put(ServerStatus.PAUSED, NodeMetadata.Status.SUSPENDED).put(ServerStatus.DUMPED, NodeMetadata.Status.PENDING).put(ServerStatus.DEAD, NodeMetadata.Status.TERMINATED).put(ServerStatus.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();
    private final Function<Server, String> getImageIdFromServer;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Location> locationSupplier;
    private final Function<Device, Volume> deviceToVolume;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    ServerInfoToNodeMetadata(Function<Server, String> getImageIdFromServer, @Memoized Supplier<Set<? extends Image>> images, Function<Device, Volume> deviceToVolume, Supplier<Location> locationSupplier, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.locationSupplier = Preconditions.checkNotNull(locationSupplier, "locationSupplier");
        this.deviceToVolume = Preconditions.checkNotNull(deviceToVolume, "deviceToVolume");
        this.images = Preconditions.checkNotNull(images, "images");
        this.getImageIdFromServer = Preconditions.checkNotNull(getImageIdFromServer, "getImageIdFromServer");
    }

    @Override
    public NodeMetadata apply(ServerInfo from) {
        Optional<Image> image;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getUuid());
        builder.name(from.getName());
        builder.location(this.locationSupplier.get());
        builder.group(ComputeServiceUtils.groupFromMapOrName(from.getUserMetadata(), from.getName(), this.nodeNamingConvention));
        builder.tags(from.getTags());
        builder.userMetadata((Map)from.getUserMetadata());
        String imageId = this.getImageIdFromServer.apply(from);
        if (imageId != null && (image = FluentIterable.from(this.images.get()).firstMatch(ImagePredicates.idEquals(imageId))).isPresent()) {
            builder.operatingSystem(image.get().getOperatingSystem());
        }
        builder.hardware(new HardwareBuilder().ids(from.getUuid()).hypervisor("kvm").processors(ImmutableList.of(new Processor(1.0, from.getCpu()))).ram(from.getMem()).volumes(Iterables.transform(from.getDevices().values(), this.deviceToVolume)).build());
        builder.status(serverStatusToNodeStatus.get((Object)from.getStatus()));
        builder.publicAddresses(ImmutableSet.of(from.getNics().get(0).getDhcp()));
        builder.privateAddresses(ImmutableSet.of());
        return builder.build();
    }

    @Singleton
    public static class GetImageIdFromServer
    implements Function<Server, String> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final LoadingCache<String, DriveInfo> cache;

        @Inject
        public GetImageIdFromServer(LoadingCache<String, DriveInfo> cache) {
            this.cache = cache;
        }

        @Override
        public String apply(Server from) {
            String imageId = null;
            if (!from.getBootDeviceIds().isEmpty()) {
                String bootDeviceId = Iterables.get(from.getBootDeviceIds(), 0);
                Device bootDevice = from.getDevices().get(bootDeviceId);
                if (bootDevice != null) {
                    try {
                        DriveInfo drive = this.cache.getUnchecked(bootDevice.getDriveUuid());
                        imageId = drive.getName();
                    }
                    catch (NullPointerException e) {
                        this.logger.debug("drive %s not found", bootDevice.getDriveUuid());
                    }
                    catch (UncheckedExecutionException e) {
                        this.logger.warn(e, "error finding drive %s: %s", bootDevice.getDriveUuid(), e.getMessage());
                    }
                }
            }
            return imageId;
        }
    }

    @Singleton
    public static final class DeviceToVolume
    implements Function<Device, Volume> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final LoadingCache<String, DriveInfo> cache;

        @Inject
        public DeviceToVolume(LoadingCache<String, DriveInfo> cache) {
            this.cache = Preconditions.checkNotNull(cache, "cache");
        }

        @Override
        public Volume apply(Device input) {
            VolumeBuilder builder = new VolumeBuilder();
            builder.id(input.getId());
            try {
                DriveInfo drive = this.cache.getUnchecked(input.getDriveUuid());
                builder.size(Float.valueOf((float)drive.getSize() / 1048576.0f));
            }
            catch (NullPointerException e) {
                this.logger.debug("drive %s not found", input.getDriveUuid());
            }
            catch (UncheckedExecutionException e) {
                this.logger.warn(e, "error finding drive %s: %s", input.getDriveUuid(), e.getMessage());
            }
            return builder.durable(true).type(Volume.Type.NAS).build();
        }
    }
}

