/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain.rdata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;

public class MXData
extends ForwardingMap<String, Object> {
    private final int preference;
    private final String exchange;
    private final transient ImmutableMap<String, Object> delegate;

    @ConstructorProperties(value={"preference", "exchange"})
    private MXData(int preference, String exchange) {
        Preconditions.checkArgument(preference >= 0, "preference of %s must be unsigned", (Object)exchange);
        this.preference = preference;
        this.exchange = Preconditions.checkNotNull(exchange, "exchange");
        this.delegate = ImmutableMap.builder().put("preference", preference).put("exchange", (Integer)((Object)exchange)).build();
    }

    public int getPreference() {
        return this.preference;
    }

    public String getExchange() {
        return this.exchange;
    }

    @Override
    protected Map<String, Object> delegate() {
        return this.delegate;
    }

    public static MXData mx(int preference, String exchange) {
        return MXData.builder().preference(preference).exchange(exchange).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return MXData.builder().from(this);
    }

    public static final class Builder {
        private int preference = -1;
        private String exchange;

        public Builder preference(int preference) {
            this.preference = preference;
            return this;
        }

        public Builder exchange(String exchange) {
            this.exchange = exchange;
            return this;
        }

        public MXData build() {
            return new MXData(this.preference, this.exchange);
        }

        public Builder from(MXData in) {
            return this.preference(in.getPreference()).exchange(in.getExchange());
        }
    }
}

