/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.dynect.v3.domain.GeoRegionGroup;
import org.jclouds.dynect.v3.domain.Node;

public class GeoService {
    private final String name;
    private final boolean active;
    private final int ttl;
    private final List<Node> nodes;
    private final List<GeoRegionGroup> groups;

    private GeoService(String name, boolean active, int ttl, List<Node> nodes, List<GeoRegionGroup> groups) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.active = active;
        this.ttl = ttl;
        this.nodes = Preconditions.checkNotNull(nodes, "nodes of %s", (Object)name);
        this.groups = Preconditions.checkNotNull(groups, "groups of %s", (Object)name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTTL() {
        return this.ttl;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<GeoRegionGroup> getGroups() {
        return this.groups;
    }

    public int hashCode() {
        return Objects.hashCode(this.active, this.name, this.nodes, this.groups);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GeoService)) {
            return false;
        }
        GeoService that = (GeoService)GeoService.class.cast(obj);
        return Objects.equal(this.active, that.active) && Objects.equal(this.name, that.name) && Objects.equal(this.ttl, that.ttl) && Objects.equal(this.nodes, that.nodes) && Objects.equal(this.groups, that.groups);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("active", this.active).add("name", this.name).add("ttl", this.ttl).add("nodes", this.nodes).add("groups", this.groups).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return GeoService.builder().from(this);
    }

    public static class Builder {
        private String name;
        private boolean active;
        protected int ttl = -1;
        private ImmutableList.Builder<Node> nodes = ImmutableList.builder();
        private ImmutableList.Builder<GeoRegionGroup> groups = ImmutableList.builder();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder addNode(Node node) {
            this.nodes.add((Object)node);
            return this;
        }

        public Builder nodes(Iterable<Node> nodes) {
            this.nodes = ImmutableList.builder().addAll(nodes);
            return this;
        }

        public Builder addAllNodes(Iterable<Node> nodes) {
            this.nodes.addAll((Iterable)nodes);
            return this;
        }

        public Builder addGroup(GeoRegionGroup group) {
            this.groups.add((Object)group);
            return this;
        }

        public Builder groups(Iterable<GeoRegionGroup> groups) {
            this.groups = ImmutableList.builder().addAll(groups);
            return this;
        }

        public Builder addAllGroups(Iterable<GeoRegionGroup> groups) {
            this.groups.addAll((Iterable)groups);
            return this;
        }

        public GeoService build() {
            return new GeoService(this.name, this.active, this.ttl, (List)((Object)this.nodes.build()), (List)((Object)this.groups.build()));
        }

        public Builder from(GeoService in) {
            return this.name(in.name).active(in.active).ttl(in.ttl).nodes(in.nodes).groups(in.groups);
        }
    }
}

