/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.inject.Named;
import org.jclouds.dynect.v3.domain.Zone;

public final class CreatePrimaryZone {
    private final transient String fqdn;
    @Named(value="rname")
    private final String contact;
    @Named(value="serial_style")
    private final Zone.SerialStyle serialStyle;
    @Named(value="ttl")
    private final int defaultTTL;

    private CreatePrimaryZone(String fqdn, String contact, Zone.SerialStyle serialStyle, int defaultTTL) {
        this.fqdn = Preconditions.checkNotNull(fqdn, "fqdn");
        this.contact = Preconditions.checkNotNull(contact, "contact for %s", (Object)fqdn);
        this.defaultTTL = defaultTTL;
        this.serialStyle = Preconditions.checkNotNull(serialStyle, "serialStyle for %s", (Object)fqdn);
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public String getContact() {
        return this.contact;
    }

    public int getDefaultTTL() {
        return this.defaultTTL;
    }

    public Zone.SerialStyle getSerialStyle() {
        return this.serialStyle;
    }

    public int hashCode() {
        return Objects.hashCode(this.fqdn, this.contact);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreatePrimaryZone that = (CreatePrimaryZone)CreatePrimaryZone.class.cast(obj);
        return Objects.equal(this.fqdn, that.fqdn) && Objects.equal(this.contact, that.contact);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("fqdn", this.fqdn).add("contact", this.contact).add("defaultTTL", this.defaultTTL).add("serialStyle", (Object)this.serialStyle).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CreatePrimaryZone.builder().from(this);
    }

    public static final class ToFQDN
    implements Function<Object, String> {
        @Override
        public String apply(Object in) {
            return ((CreatePrimaryZone)CreatePrimaryZone.class.cast(in)).getFQDN();
        }
    }

    public static final class Builder {
        private String fqdn;
        private String contact;
        private int defaultTTL = 3600;
        private Zone.SerialStyle serialStyle = Zone.SerialStyle.INCREMENT;

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public Builder contact(String contact) {
            this.contact = contact;
            return this;
        }

        public Builder defaultTTL(int defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public Builder serialStyle(Zone.SerialStyle serialStyle) {
            this.serialStyle = serialStyle;
            return this;
        }

        public CreatePrimaryZone build() {
            return new CreatePrimaryZone(this.fqdn, this.contact, this.serialStyle, this.defaultTTL);
        }

        public Builder from(CreatePrimaryZone in) {
            return this.fqdn(in.fqdn).contact(in.contact).serialStyle(in.serialStyle).defaultTTL(in.defaultTTL);
        }
    }
}

