/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import org.jclouds.dynect.v3.domain.RecordId;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.rest.Binder;

public class RecordIdBinder
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object recordId) {
        RecordId valueToAppend = (RecordId)RecordId.class.cast(Preconditions.checkNotNull(recordId, "recordId"));
        URI path = Uris.uriBuilder(request.getEndpoint()).appendPath("/{type}Record/{zone}/{fqdn}/{id}").build(ImmutableMap.builder().put("type", valueToAppend.getType()).put("zone", valueToAppend.getZone()).put("fqdn", valueToAppend.getFQDN()).put("id", (String)((Object)Long.valueOf(valueToAppend.getId()))).build());
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(path)).build();
    }
}

