/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.digitalocean2.ssh.DSAKeys;
import org.jclouds.digitalocean2.ssh.ECDSAKeys;
import org.jclouds.json.config.GsonModule;
import org.jclouds.ssh.SshKeys;

public class DigitalOceanParserModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public Function<PublicKey, String> publicKeyToSshKey() {
        return new Function<PublicKey, String>(){

            @Override
            public String apply(PublicKey input) {
                if (input instanceof RSAPublicKey) {
                    return SshKeys.encodeAsOpenSSH((RSAPublicKey)input);
                }
                if (input instanceof DSAPublicKey) {
                    return DSAKeys.encodeAsOpenSSH((DSAPublicKey)input);
                }
                throw new IllegalArgumentException("Only RSA and DSA keys are supported");
            }
        };
    }

    @Provides
    @Singleton
    public Function<String, PublicKey> sshKeyToPublicKey() {
        return new Function<String, PublicKey>(){

            @Override
            public PublicKey apply(String input) {
                Iterable<String> parts = Splitter.on(' ').split(input);
                Preconditions.checkArgument(Iterables.size(parts) >= 2, "bad format, should be: [ssh-rsa|ssh-dss] AAAAB3...");
                String type = Iterables.get(parts, 0);
                try {
                    if ("ssh-rsa".equals(type)) {
                        RSAPublicKeySpec spec = SshKeys.publicKeySpecFromOpenSSH(input);
                        return KeyFactory.getInstance("RSA").generatePublic(spec);
                    }
                    if ("ssh-dss".equals(type)) {
                        DSAPublicKeySpec spec = DSAKeys.publicKeySpecFromOpenSSH(input);
                        return KeyFactory.getInstance("DSA").generatePublic(spec);
                    }
                    if (type.startsWith("ecdsa-sha2-")) {
                        ECPublicKeySpec spec = ECDSAKeys.publicKeySpecFromOpenSSH(input);
                        return KeyFactory.getInstance("EC").generatePublic(spec);
                    }
                    throw new IllegalArgumentException("bad format, jclouds supports ssh-rsa, ssh-dss, ecdsa-sha2-nistp[256|384|521]");
                }
                catch (InvalidKeySpecException ex) {
                    throw Throwables.propagate(ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw Throwables.propagate(ex);
                }
            }
        };
    }

    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings(SshPublicKeyAdapter sshPublicKeyAdapter) {
        return ImmutableMap.of(PublicKey.class, sshPublicKeyAdapter);
    }

    @Singleton
    public static class SshPublicKeyAdapter
    extends TypeAdapter<PublicKey> {
        private final Function<PublicKey, String> publicKeyToSshKey;
        private final Function<String, PublicKey> sshKeyToPublicKey;

        @Inject
        public SshPublicKeyAdapter(Function<PublicKey, String> publicKeyToSshKey, Function<String, PublicKey> sshKeyToPublicKey) {
            this.publicKeyToSshKey = Preconditions.checkNotNull(publicKeyToSshKey, "publicKeyToSshKey cannot be null");
            this.sshKeyToPublicKey = Preconditions.checkNotNull(sshKeyToPublicKey, "sshKeyToPublicKey cannot be null");
        }

        @Override
        public void write(JsonWriter out, PublicKey value) throws IOException {
            out.value(this.publicKeyToSshKey.apply(value));
        }

        @Override
        public PublicKey read(JsonReader in) throws IOException {
            return this.sshKeyToPublicKey.apply(in.nextString().trim());
        }
    }
}

