/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.cloudwatch.domain.HistoryItemType;

@Beta
public class AlarmHistoryItem {
    private final String alarmName;
    private final String historyData;
    private final HistoryItemType historyItemType;
    private final String historySummary;
    private final Date timestamp;

    public AlarmHistoryItem(String alarmName, String historyData, HistoryItemType historyItemType, String historySummary, Date timestamp) {
        this.alarmName = Preconditions.checkNotNull(alarmName, "alarmName");
        this.historyData = Preconditions.checkNotNull(historyData, "historyData for %s", (Object)alarmName);
        this.historyItemType = Preconditions.checkNotNull(historyItemType, "historyItemType for %s", (Object)alarmName);
        this.historySummary = Preconditions.checkNotNull(historySummary, "historySummary for %s", (Object)alarmName);
        this.timestamp = Preconditions.checkNotNull(timestamp, "timestamp for %s", (Object)alarmName);
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public String getHistoryData() {
        return this.historyData;
    }

    public HistoryItemType getHistoryItemType() {
        return this.historyItemType;
    }

    public String getHistorySummary() {
        return this.historySummary;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.alarmName, this.historyData, this.historyItemType, this.historySummary, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlarmHistoryItem other = (AlarmHistoryItem)obj;
        return Objects.equal(this.alarmName, other.alarmName) && Objects.equal(this.historyData, other.historyData) && Objects.equal((Object)this.historyItemType, (Object)other.historyItemType) && Objects.equal(this.historySummary, other.historySummary) && Objects.equal(this.timestamp, other.timestamp);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("alarmName", this.alarmName).add("historyData", this.historyData).add("historyItemType", (Object)this.historyItemType).add("historySummary", this.historySummary).add("timestamp", this.timestamp).toString();
    }
}

