/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;

@Beta
public class Alarm {
    private final boolean areActionsEnabled;
    private final Set<String> alarmActions;
    private final String alarmARN;
    private final Date alarmConfigurationUpdatedTimestamp;
    private final String alarmDescription;
    private final String alarmName;
    private final ComparisonOperator comparisonOperator;
    private final Set<Dimension> dimensions;
    private final int evaluationPeriods;
    private final Set<String> insufficientDataActions;
    private final String metricName;
    private final String namespace;
    private final Set<String> okActions;
    private final int period;
    private final String stateReason;
    private final Optional<String> stateReasonData;
    private final Date stateUpdatedTimestamp;
    private final State state;
    private final Statistics statistic;
    private final double threshold;
    private final Optional<Unit> unit;

    public Alarm(boolean areActionsEnabled, Set<String> alarmActions, String alarmARN, Date alarmConfigurationUpdatedTimestamp, String alarmDescription, String alarmName, ComparisonOperator comparisonOperator, Set<Dimension> dimensions, int evaluationPeriods, Set<String> insufficientDataActions, String metricName, String namespace, Set<String> okActions, int period, String stateReason, Optional<String> stateReasonData, Date stateUpdatedTimestamp, State state, Statistics statistic, double threshold, Optional<Unit> unit) {
        this.alarmName = Preconditions.checkNotNull(alarmName, "alarmName");
        this.areActionsEnabled = areActionsEnabled;
        this.alarmActions = Preconditions.checkNotNull(alarmActions, "alarmActions for %s", (Object)alarmName);
        this.alarmARN = Preconditions.checkNotNull(alarmARN, "alarmArn for %s", (Object)alarmName);
        this.alarmConfigurationUpdatedTimestamp = Preconditions.checkNotNull(alarmConfigurationUpdatedTimestamp, "alarmConfigurationUpdatedTimestamp for %s", (Object)alarmName);
        this.alarmDescription = Preconditions.checkNotNull(alarmDescription, "alarmDescription for %s", (Object)alarmName);
        this.comparisonOperator = Preconditions.checkNotNull(comparisonOperator, "comparisonOperator for %s", (Object)alarmName);
        Preconditions.checkArgument(comparisonOperator != ComparisonOperator.UNRECOGNIZED, "comparisonOperator unrecognized");
        this.dimensions = Preconditions.checkNotNull(dimensions, "dimensions for %s", (Object)alarmName);
        this.evaluationPeriods = evaluationPeriods;
        this.insufficientDataActions = Preconditions.checkNotNull(insufficientDataActions, "insufficientDataActions for %s", (Object)alarmName);
        this.metricName = Preconditions.checkNotNull(metricName, "metricName for %s", (Object)alarmName);
        this.namespace = Preconditions.checkNotNull(namespace, "namespace for %s", (Object)alarmName);
        this.okActions = Preconditions.checkNotNull(okActions, "okActions for %s", (Object)alarmName);
        this.period = period;
        this.stateReason = Preconditions.checkNotNull(stateReason, "stateReason for %s", (Object)alarmName);
        this.stateReasonData = Preconditions.checkNotNull(stateReasonData, "stateReasonData for %s", (Object)alarmName);
        this.stateUpdatedTimestamp = Preconditions.checkNotNull(stateUpdatedTimestamp, "stateUpdatedTimestamp for %s", (Object)alarmName);
        this.state = Preconditions.checkNotNull(state, "state for %s", (Object)alarmName);
        Preconditions.checkArgument(state != State.UNRECOGNIZED, "state unrecognized");
        this.statistic = Preconditions.checkNotNull(statistic, "statistic for %s", (Object)alarmName);
        Preconditions.checkArgument(statistic != Statistics.UNRECOGNIZED, "statistic unrecognized");
        this.threshold = threshold;
        this.unit = Preconditions.checkNotNull(unit, "unit for %s", (Object)alarmName);
        if (unit.isPresent()) {
            Preconditions.checkArgument(unit.get() != Unit.UNRECOGNIZED, "unit unrecognized");
        }
    }

    public boolean areActionsEnabled() {
        return this.areActionsEnabled;
    }

    public Set<String> getAlarmActions() {
        return this.alarmActions;
    }

    public String getAlarmARN() {
        return this.alarmARN;
    }

    public Date getAlarmConfigurationUpdatedTimestamp() {
        return this.alarmConfigurationUpdatedTimestamp;
    }

    public String getAlarmDescription() {
        return this.alarmDescription;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    public int getEvaluationPeriods() {
        return this.evaluationPeriods;
    }

    public Set<String> getInsufficientDataActions() {
        return this.insufficientDataActions;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Set<String> getOkActions() {
        return this.okActions;
    }

    public int getPeriod() {
        return this.period;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public Optional<String> getStateReasonData() {
        return this.stateReasonData;
    }

    public Date getStateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public State getState() {
        return this.state;
    }

    public Statistics getStatistic() {
        return this.statistic;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Optional<Unit> getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.alarmActions, this.alarmARN, this.alarmConfigurationUpdatedTimestamp, this.alarmDescription, this.alarmName, this.areActionsEnabled, this.comparisonOperator, this.dimensions, this.evaluationPeriods, this.insufficientDataActions, this.metricName, this.namespace, this.okActions, this.period, this.stateReason, this.stateReasonData, this.stateUpdatedTimestamp, this.state, this.statistic, this.threshold, this.unit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alarm other = (Alarm)obj;
        return Objects.equal(this.alarmActions, other.alarmActions) && Objects.equal(this.alarmARN, other.alarmARN) && Objects.equal(this.alarmConfigurationUpdatedTimestamp, other.alarmConfigurationUpdatedTimestamp) && Objects.equal(this.alarmDescription, other.alarmDescription) && Objects.equal(this.alarmName, other.alarmName) && Objects.equal(this.areActionsEnabled, other.areActionsEnabled) && Objects.equal((Object)this.comparisonOperator, (Object)other.comparisonOperator) && Objects.equal(this.dimensions, other.dimensions) && Objects.equal(this.evaluationPeriods, other.evaluationPeriods) && Objects.equal(this.insufficientDataActions, other.insufficientDataActions) && Objects.equal(this.metricName, other.metricName) && Objects.equal(this.namespace, other.namespace) && Objects.equal(this.okActions, other.okActions) && Objects.equal(this.period, other.period) && Objects.equal(this.stateReason, other.stateReason) && Objects.equal(this.stateReasonData, other.stateReasonData) && Objects.equal(this.stateUpdatedTimestamp, other.stateUpdatedTimestamp) && Objects.equal((Object)this.state, (Object)other.state) && Objects.equal((Object)this.statistic, (Object)other.statistic) && Objects.equal(this.threshold, other.threshold) && Objects.equal(this.unit, other.unit);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("alarmActions", this.alarmActions).add("alarmARN", this.alarmARN).add("alarmConfigurationUpdateTimestamp", this.alarmConfigurationUpdatedTimestamp).add("alarmDescription", this.alarmDescription).add("alarmName", this.alarmName).add("areActionsEnabled", this.areActionsEnabled).add("comparisonOperator", (Object)this.comparisonOperator).add("dimensions", this.dimensions).add("evaluationPeriods", this.evaluationPeriods).add("insufficientDataActions", this.insufficientDataActions).add("metricName", this.metricName).add("namespace", this.namespace).add("okActions", this.okActions).add("period", this.period).add("stateReason", this.stateReason).add("stateReasonData", this.stateReasonData.orNull()).add("stateUpdatedTimestamp", this.stateUpdatedTimestamp).add("state", (Object)this.state).add("statistic", (Object)this.statistic).add("threshold", this.threshold).add("unit", (Object)this.unit.orNull()).toString();
    }

    public static enum State {
        ALARM,
        INSUFFICIENT_DATA,
        OK,
        UNRECOGNIZED;


        public static State fromValue(String value) {
            try {
                return State.valueOf(Preconditions.checkNotNull(value, "value"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

