/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.binders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Beta
public class AlarmNamesBinder
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Iterable alarmNames = (Iterable)Preconditions.checkNotNull(input, "alarm names must be set");
        ImmutableMultimap.Builder<String, String> formParameters = ImmutableMultimap.builder();
        int alarmNameIndex = 1;
        for (String alarmName : alarmNames) {
            formParameters.put("AlarmNames.member." + alarmNameIndex, alarmName);
            ++alarmNameIndex;
        }
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(formParameters.build())).build();
    }
}

