/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.javax.annotation.Nullable;

public class Snapshot {
    private final String id;
    private final String account;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final Interval interval;
    private final String jobId;
    private final String jobStatus;
    private final String name;
    private final Type snapshotType;
    private final State state;
    private final String volumeId;
    private final String volumeName;
    private final Volume.Type volumeType;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSnapshot(this);
    }

    @ConstructorProperties(value={"id", "account", "created", "domain", "domainid", "intervaltype", "jobid", "jobstatus", "name", "snapshottype", "state", "volumeid", "volumename", "volumetype", "tags"})
    protected Snapshot(String id, @Nullable String account, @Nullable Date created, @Nullable String domain, @Nullable String domainId, @Nullable Interval interval, @Nullable String jobId, @Nullable String jobStatus, @Nullable String name, @Nullable Type snapshotType, @Nullable State state, @Nullable String volumeId, @Nullable String volumeName, @Nullable Volume.Type volumeType, @Nullable Set<Tag> tags) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.account = account;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.interval = interval;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.name = name;
        this.snapshotType = snapshotType;
        this.state = state;
        this.volumeId = volumeId;
        this.volumeName = volumeName;
        this.volumeType = volumeType;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public String getJobStatus() {
        return this.jobStatus;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Type getSnapshotType() {
        return this.snapshotType;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getVolumeId() {
        return this.volumeId;
    }

    @Nullable
    public String getVolumeName() {
        return this.volumeName;
    }

    @Nullable
    public Volume.Type getVolumeType() {
        return this.volumeType;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.account, this.created, this.domain, this.domainId, this.interval, this.jobId, this.jobStatus, this.name, this.snapshotType, this.state, this.volumeId, this.volumeName, this.volumeType, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)Snapshot.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.account, that.account) && Objects.equal(this.created, that.created) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal((Object)this.interval, (Object)that.interval) && Objects.equal(this.jobId, that.jobId) && Objects.equal(this.jobStatus, that.jobStatus) && Objects.equal(this.name, that.name) && Objects.equal((Object)this.snapshotType, (Object)that.snapshotType) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.volumeId, that.volumeId) && Objects.equal(this.volumeName, that.volumeName) && Objects.equal((Object)this.volumeType, (Object)that.volumeType) && Objects.equal(this.tags, that.tags);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("account", this.account).add("created", this.created).add("domain", this.domain).add("domainId", this.domainId).add("interval", (Object)this.interval).add("jobId", this.jobId).add("jobStatus", this.jobStatus).add("name", this.name).add("snapshotType", (Object)this.snapshotType).add("state", (Object)this.state).add("volumeId", this.volumeId).add("volumeName", this.volumeName).add("volumeType", (Object)this.volumeType).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected Interval interval;
        protected String jobId;
        protected String jobStatus;
        protected String name;
        protected Type snapshotType;
        protected State state;
        protected String volumeId;
        protected String volumeName;
        protected Volume.Type volumeType;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T interval(Interval interval) {
            this.interval = interval;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T snapshotType(Type snapshotType) {
            this.snapshotType = snapshotType;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this.self();
        }

        public T volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this.self();
        }

        public T volumeType(Volume.Type volumeType) {
            this.volumeType = volumeType;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(tags, "tags"));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags(ImmutableSet.copyOf(in));
        }

        public Snapshot build() {
            return new Snapshot(this.id, this.account, this.created, this.domain, this.domainId, this.interval, this.jobId, this.jobStatus, this.name, this.snapshotType, this.state, this.volumeId, this.volumeName, this.volumeType, this.tags);
        }

        public T fromSnapshot(Snapshot in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).interval(in.getInterval())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).name(in.getName())).snapshotType(in.getSnapshotType())).state(in.getState())).volumeId(in.getVolumeId())).volumeName(in.getVolumeName())).volumeType(in.getVolumeType())).tags(in.getTags());
        }
    }

    public static enum Interval {
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        template,
        none,
        UNRECOGNIZED;


        public static Interval fromValue(String type) {
            try {
                return Interval.valueOf(Preconditions.checkNotNull(type, "type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        MANUAL,
        RECURRING,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf(Preconditions.checkNotNull(type, "type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        BACKED_UP,
        CREATING,
        BACKING_UP,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

