/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class RunListBuilder {
    private List<String> list = Lists.newArrayList();

    public RunListBuilder addRecipe(String recipe) {
        return this.addRecipes(Preconditions.checkNotNull(recipe, "recipe"));
    }

    public RunListBuilder addRecipes(String ... recipes) {
        Iterables.addAll(this.list, Lists.transform(Arrays.asList(Preconditions.checkNotNull(recipes, "recipes")), new Function<String, String>(){

            @Override
            public String apply(String from) {
                return "recipe[" + from + "]";
            }
        }));
        return this;
    }

    public RunListBuilder addRole(String role) {
        return this.addRoles(Preconditions.checkNotNull(role, "role"));
    }

    public RunListBuilder addRoles(String ... roles) {
        Iterables.addAll(this.list, Lists.transform(Arrays.asList(Preconditions.checkNotNull(roles, "roles")), new Function<String, String>(){

            @Override
            public String apply(String from) {
                return "role[" + from + "]";
            }
        }));
        return this;
    }

    public List<String> build() {
        return ImmutableList.copyOf(this.list);
    }
}

