/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.ListNodes;
import org.jclouds.chef.strategy.internal.BaseListNodesImpl;
import org.jclouds.logging.Logger;

@Singleton
public class ListNodesImpl
extends BaseListNodesImpl
implements ListNodes {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListNodesImpl(ChefApi api) {
        super(api);
    }

    @Override
    public Iterable<? extends Node> execute() {
        return super.execute(this.api.listNodes());
    }

    @Override
    public Iterable<? extends Node> execute(ExecutorService executor) {
        return this.executeConcurrently(MoreExecutors.listeningDecorator(executor));
    }

    private Iterable<? extends Node> executeConcurrently(ListeningExecutorService executor) {
        return super.executeConcurrently(executor, this.api.listNodes());
    }
}

