/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.strategy.ListClients;
import org.jclouds.logging.Logger;

@Singleton
public class ListClientsImpl
implements ListClients {
    protected final ChefApi api;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListClientsImpl(ChefApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    public Iterable<? extends Client> execute() {
        Set<String> toGet = this.api.listClients();
        Iterable<Client> clients = Iterables.transform(toGet, new Function<String, Client>(){

            @Override
            public Client apply(String input) {
                return ListClientsImpl.this.api.getClient(input);
            }
        });
        this.logger.trace(String.format("getting clients: %s", Joiner.on(',').join(toGet)), new Object[0]);
        return clients;
    }

    @Override
    public Iterable<? extends Client> execute(ExecutorService executorService) {
        return this.execute(MoreExecutors.listeningDecorator(executorService));
    }

    private Iterable<? extends Client> execute(ListeningExecutorService listeningExecutor) {
        return this.executeConcurrently(listeningExecutor, this.api.listClients());
    }

    private Iterable<? extends Client> executeConcurrently(final ListeningExecutorService executor, Iterable<String> toGet) {
        ListenableFuture<List<Client>> futures = Futures.allAsList(Iterables.transform(toGet, new Function<String, ListenableFuture<Client>>(){

            @Override
            public ListenableFuture<Client> apply(final String input) {
                return executor.submit(new Callable<Client>(){

                    @Override
                    public Client call() throws Exception {
                        return ListClientsImpl.this.api.getClient(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("getting clients: %s", Joiner.on(',').join(toGet)), new Object[0]);
        return Futures.getUnchecked(futures);
    }
}

