/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.logging.Logger;

public abstract class BaseListCookbookVersionsImpl {
    protected final ChefApi api;
    protected Logger logger = Logger.NULL;

    BaseListCookbookVersionsImpl(ChefApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    protected Iterable<? extends CookbookVersion> execute(Iterable<String> toGet) {
        return Iterables.concat(Iterables.transform(toGet, new Function<String, Iterable<? extends CookbookVersion>>(){

            @Override
            public Iterable<? extends CookbookVersion> apply(final String cookbook) {
                Set<String> cookbookVersions = BaseListCookbookVersionsImpl.this.api.listVersionsOfCookbook(cookbook);
                Iterable<CookbookVersion> cookbooksVersions = Iterables.transform(cookbookVersions, new Function<String, CookbookVersion>(){

                    @Override
                    public CookbookVersion apply(String version) {
                        return BaseListCookbookVersionsImpl.this.api.getCookbook(cookbook, version);
                    }
                });
                BaseListCookbookVersionsImpl.this.logger.trace(String.format("getting versions of cookbook: %s", cookbook), new Object[0]);
                return cookbooksVersions;
            }
        }));
    }

    protected Iterable<? extends CookbookVersion> executeConcurrently(final ListeningExecutorService executor, Iterable<String> cookbookNames) {
        return Iterables.concat(Iterables.transform(cookbookNames, new Function<String, Iterable<? extends CookbookVersion>>(){

            @Override
            public Iterable<? extends CookbookVersion> apply(final String cookbook) {
                Set<String> cookbookVersions = BaseListCookbookVersionsImpl.this.api.listVersionsOfCookbook(cookbook);
                ListenableFuture<List<CookbookVersion>> futures = Futures.allAsList(Iterables.transform(cookbookVersions, new Function<String, ListenableFuture<CookbookVersion>>(){

                    @Override
                    public ListenableFuture<CookbookVersion> apply(final String version) {
                        return executor.submit(new Callable<CookbookVersion>(){

                            @Override
                            public CookbookVersion call() throws Exception {
                                return BaseListCookbookVersionsImpl.this.api.getCookbook(cookbook, version);
                            }
                        });
                    }
                }));
                BaseListCookbookVersionsImpl.this.logger.trace(String.format("getting versions of cookbook: %s", cookbook), new Object[0]);
                return Futures.getUnchecked(futures);
            }
        }));
    }
}

