/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class ParseCookbookDefinitionFromJson
implements Function<HttpResponse, CookbookDefinition> {
    private final ParseJson<Map<String, CookbookDefinition>> parser;

    @Inject
    ParseCookbookDefinitionFromJson(ParseJson<Map<String, CookbookDefinition>> parser) {
        this.parser = parser;
    }

    @Override
    public CookbookDefinition apply(HttpResponse response) {
        Map<String, CookbookDefinition> result = this.parser.apply(response);
        String cookbookName = result.keySet().iterator().next();
        CookbookDefinition def = result.values().iterator().next();
        return CookbookDefinition.builder().from(def).name(cookbookName).build();
    }
}

