/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.domain.JsonBall;
import org.jclouds.javax.annotation.Nullable;

public class Role {
    private final String name;
    private final String description;
    @SerializedName(value="override_attributes")
    private final Map<String, JsonBall> overrideAttributes;
    @SerializedName(value="default_attributes")
    private final Map<String, JsonBall> defaultAttributes;
    @SerializedName(value="run_list")
    private final List<String> runList;
    @SerializedName(value="env_run_lists")
    private Map<String, List<String>> envRunList;
    @SerializedName(value="json_class")
    private final String _jsonClass = "Chef::Role";
    @SerializedName(value="chef_type")
    private final String _chefType = "role";

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"name", "description", "default_attributes", "run_list", "override_attributes", "env_run_lists"})
    protected Role(String name, String description, @Nullable Map<String, JsonBall> defaultAttributes, @Nullable List<String> runList, @Nullable Map<String, JsonBall> overrideAttributes, @Nullable Map<String, List<String>> envRunList) {
        this.name = name;
        this.description = description;
        this.defaultAttributes = CollectionUtils.copyOfOrEmpty(defaultAttributes);
        this.runList = CollectionUtils.copyOfOrEmpty(runList);
        this.overrideAttributes = CollectionUtils.copyOfOrEmpty(overrideAttributes);
        this.envRunList = envRunList;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, JsonBall> getOverrideAttributes() {
        return this.overrideAttributes;
    }

    public Map<String, JsonBall> getDefaultAttributes() {
        return this.defaultAttributes;
    }

    public List<String> getRunList() {
        return this.runList;
    }

    public Map<String, List<String>> getEnvRunList() {
        return this.envRunList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ("role" == null ? 0 : "role".hashCode());
        result = 31 * result + ("Chef::Role" == null ? 0 : "Chef::Role".hashCode());
        result = 31 * result + (this.defaultAttributes == null ? 0 : this.defaultAttributes.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.overrideAttributes == null ? 0 : this.overrideAttributes.hashCode());
        result = 31 * result + (this.runList == null ? 0 : this.runList.hashCode());
        result = 31 * result + (this.envRunList == null ? 0 : this.envRunList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if ("role" == null ? other._chefType != null : !"role".equals(other._chefType)) {
            return false;
        }
        if ("Chef::Role" == null ? other._jsonClass != null : !"Chef::Role".equals(other._jsonClass)) {
            return false;
        }
        if (this.defaultAttributes == null ? other.defaultAttributes != null : !this.defaultAttributes.equals(other.defaultAttributes)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.overrideAttributes == null ? other.overrideAttributes != null : !this.overrideAttributes.equals(other.overrideAttributes)) {
            return false;
        }
        if (this.runList == null ? other.runList != null : !this.runList.equals(other.runList)) {
            return false;
        }
        return !(this.envRunList == null ? other.envRunList != null : !this.envRunList.equals(other.envRunList));
    }

    public String toString() {
        return "Role [name=" + this.name + ", description=" + this.description + ", defaultAttributes=" + this.defaultAttributes + ", overrideAttributes=" + this.overrideAttributes + ", runList=" + this.runList + ", envRunList=" + this.envRunList + "]";
    }

    public static class Builder {
        private String name;
        private String description;
        private ImmutableMap.Builder<String, JsonBall> overrideAttributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, JsonBall> defaultAttributes = ImmutableMap.builder();
        private ImmutableList.Builder<String> runList = ImmutableList.builder();
        private Map<String, List<String>> envRunList = new HashMap<String, List<String>>();

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder description(String description) {
            this.description = Preconditions.checkNotNull(description, "description");
            return this;
        }

        public Builder overrideAttribute(String key, JsonBall value) {
            this.overrideAttributes.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder overrideAttributes(Map<String, JsonBall> overrideAttributes) {
            this.overrideAttributes.putAll(Preconditions.checkNotNull(overrideAttributes, "overrideAttributes"));
            return this;
        }

        public Builder defaultAttribute(String key, JsonBall value) {
            this.defaultAttributes.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder defaultAttributes(Map<String, JsonBall> defaultAttributes) {
            this.defaultAttributes.putAll(Preconditions.checkNotNull(defaultAttributes, "defaultAttributes"));
            return this;
        }

        public Builder runListElement(String element) {
            this.runList.add((Object)Preconditions.checkNotNull(element, "element"));
            return this;
        }

        public Builder runList(Iterable<String> runList) {
            this.runList.addAll((Iterable)Preconditions.checkNotNull(runList, "runList"));
            return this;
        }

        public Builder envRunList(Map<String, List<String>> envRunList) {
            this.envRunList.putAll(Preconditions.checkNotNull(envRunList, "envRunList"));
            return this;
        }

        public Builder envRunList(String name, List<String> runList) {
            this.envRunList.put(Preconditions.checkNotNull(name, "name"), Preconditions.checkNotNull(runList, "runList"));
            return this;
        }

        public Builder envRunListElement(String name, String value) {
            Preconditions.checkNotNull(name, "name");
            Preconditions.checkNotNull(value, "value");
            List<String> runList = this.envRunList.get(name);
            if (runList == null) {
                runList = new ArrayList<String>();
                this.envRunList.put(name, runList);
            }
            runList.add(value);
            return this;
        }

        public Role build() {
            Map<String, List<String>> immutableEnvRunList = Maps.transformValues(this.envRunList, new Function<List<String>, List<String>>(){

                @Override
                public List<String> apply(List<String> input) {
                    return ImmutableList.copyOf(input);
                }
            });
            return new Role(this.name, this.description, this.defaultAttributes.build(), (List<String>)((Object)this.runList.build()), this.overrideAttributes.build(), immutableEnvRunList);
        }
    }
}

