/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.chef.domain.Metadata;
import org.jclouds.chef.domain.Resource;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.javax.annotation.Nullable;

public class CookbookVersion {
    private final String name;
    private final Set<Resource> definitions;
    private final Set<Resource> attributes;
    private final Set<Resource> files;
    private final Metadata metadata;
    private final Set<Resource> providers;
    @SerializedName(value="cookbook_name")
    private final String cookbookName;
    private final Set<Resource> resources;
    private final Set<Resource> templates;
    private final Set<Resource> libraries;
    private final String version;
    private final Set<Resource> recipes;
    @SerializedName(value="root_files")
    private final Set<Resource> rootFiles;
    @SerializedName(value="json_class")
    private String _jsonClass = "Chef::CookbookVersion";
    @SerializedName(value="chef_type")
    private String _chefType = "cookbook_version";

    public static Builder builder(String name, String version) {
        return new Builder(name, version);
    }

    @ConstructorProperties(value={"name", "definitions", "attributes", "files", "metadata", "providers", "cookbook_name", "resources", "templates", "libraries", "version", "recipes", "root_files"})
    protected CookbookVersion(String name, @Nullable Set<Resource> definitions, @Nullable Set<Resource> attributes, @Nullable Set<Resource> files, Metadata metadata, @Nullable Set<Resource> providers, String cookbookName, @Nullable Set<Resource> resources, @Nullable Set<Resource> templates, @Nullable Set<Resource> libraries, String version, @Nullable Set<Resource> recipes, @Nullable Set<Resource> rootFiles) {
        this.name = name;
        this.definitions = CollectionUtils.copyOfOrEmpty(definitions);
        this.attributes = CollectionUtils.copyOfOrEmpty(attributes);
        this.files = CollectionUtils.copyOfOrEmpty(files);
        this.metadata = metadata;
        this.providers = CollectionUtils.copyOfOrEmpty(providers);
        this.cookbookName = cookbookName;
        this.resources = CollectionUtils.copyOfOrEmpty(resources);
        this.templates = CollectionUtils.copyOfOrEmpty(templates);
        this.libraries = CollectionUtils.copyOfOrEmpty(libraries);
        this.version = version;
        this.recipes = CollectionUtils.copyOfOrEmpty(recipes);
        this.rootFiles = CollectionUtils.copyOfOrEmpty(rootFiles);
    }

    public String getName() {
        return this.name;
    }

    public Set<Resource> getDefinitions() {
        return this.definitions;
    }

    public Set<Resource> getAttributes() {
        return this.attributes;
    }

    public Set<Resource> getFiles() {
        return this.files;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Set<Resource> getSuppliers() {
        return this.providers;
    }

    public String getCookbookName() {
        return this.cookbookName;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public Set<Resource> getTemplates() {
        return this.templates;
    }

    public Set<Resource> getLibraries() {
        return this.libraries;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<Resource> getRecipes() {
        return this.recipes;
    }

    public Set<Resource> getRootFiles() {
        return this.rootFiles;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.cookbookName == null ? 0 : this.cookbookName.hashCode());
        result = 31 * result + (this.definitions == null ? 0 : this.definitions.hashCode());
        result = 31 * result + (this.files == null ? 0 : this.files.hashCode());
        result = 31 * result + (this.libraries == null ? 0 : this.libraries.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.providers == null ? 0 : this.providers.hashCode());
        result = 31 * result + (this.recipes == null ? 0 : this.recipes.hashCode());
        result = 31 * result + (this.resources == null ? 0 : this.resources.hashCode());
        result = 31 * result + (this.rootFiles == null ? 0 : this.rootFiles.hashCode());
        result = 31 * result + (this.templates == null ? 0 : this.templates.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CookbookVersion other = (CookbookVersion)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.cookbookName == null ? other.cookbookName != null : !this.cookbookName.equals(other.cookbookName)) {
            return false;
        }
        if (this.definitions == null ? other.definitions != null : !this.definitions.equals(other.definitions)) {
            return false;
        }
        if (this.files == null ? other.files != null : !this.files.equals(other.files)) {
            return false;
        }
        if (this.libraries == null ? other.libraries != null : !this.libraries.equals(other.libraries)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.providers == null ? other.providers != null : !this.providers.equals(other.providers)) {
            return false;
        }
        if (this.recipes == null ? other.recipes != null : !this.recipes.equals(other.recipes)) {
            return false;
        }
        if (this.resources == null ? other.resources != null : !this.resources.equals(other.resources)) {
            return false;
        }
        if (this.rootFiles == null ? other.rootFiles != null : !this.rootFiles.equals(other.rootFiles)) {
            return false;
        }
        if (this.templates == null ? other.templates != null : !this.templates.equals(other.templates)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "Cookbook [attributes=" + this.attributes + ", cookbookName=" + this.cookbookName + ", definitions=" + this.definitions + ", files=" + this.files + ", libraries=" + this.libraries + ", metadata=" + this.metadata + ", name=" + this.name + ", providers=" + this.providers + ", recipes=" + this.recipes + ", resources=" + this.resources + ", rootFiles=" + this.rootFiles + ", templates=" + this.templates + ", version=" + this.version + "]";
    }

    public static class Builder {
        private String cookbookName;
        private ImmutableSet.Builder<Resource> definitions = ImmutableSet.builder();
        private ImmutableSet.Builder<Resource> attributes = ImmutableSet.builder();
        private ImmutableSet.Builder<Resource> files = ImmutableSet.builder();
        private Metadata metadata = Metadata.builder().build();
        private ImmutableSet.Builder<Resource> providers = ImmutableSet.builder();
        private ImmutableSet.Builder<Resource> resources = ImmutableSet.builder();
        private ImmutableSet.Builder<Resource> templates = ImmutableSet.builder();
        private ImmutableSet.Builder<Resource> libraries = ImmutableSet.builder();
        private String version;
        private ImmutableSet.Builder<Resource> recipes = ImmutableSet.builder();
        private ImmutableSet.Builder<Resource> rootFiles = ImmutableSet.builder();

        public Builder(String name, String version) {
            this.cookbookName = Preconditions.checkNotNull(name, "name");
            this.version = Preconditions.checkNotNull(version, "version");
        }

        public Builder cookbookName(String cookbookName) {
            this.cookbookName = Preconditions.checkNotNull(cookbookName, "cookbookName");
            return this;
        }

        public Builder definition(Resource definition) {
            this.definitions.add((Object)Preconditions.checkNotNull(definition, "definition"));
            return this;
        }

        public Builder definitions(Iterable<Resource> definitions) {
            this.definitions.addAll((Iterable)Preconditions.checkNotNull(definitions, "definitions"));
            return this;
        }

        public Builder attribute(Resource attribute) {
            this.attributes.add((Object)Preconditions.checkNotNull(attribute, "attribute"));
            return this;
        }

        public Builder attributes(Iterable<Resource> attributes) {
            this.attributes.addAll((Iterable)Preconditions.checkNotNull(attributes, "attributes"));
            return this;
        }

        public Builder file(Resource file) {
            this.files.add((Object)Preconditions.checkNotNull(file, "file"));
            return this;
        }

        public Builder files(Iterable<Resource> files) {
            this.files.addAll((Iterable)Preconditions.checkNotNull(files, "files"));
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = Preconditions.checkNotNull(metadata, "metadata");
            return this;
        }

        public Builder provider(Resource provider) {
            this.providers.add((Object)Preconditions.checkNotNull(provider, "provider"));
            return this;
        }

        public Builder providers(Iterable<Resource> providers) {
            this.providers.addAll((Iterable)Preconditions.checkNotNull(providers, "providers"));
            return this;
        }

        public Builder resource(Resource resource) {
            this.resources.add((Object)Preconditions.checkNotNull(resource, "resource"));
            return this;
        }

        public Builder resources(Iterable<Resource> resources) {
            this.resources.addAll((Iterable)Preconditions.checkNotNull(resources, "resources"));
            return this;
        }

        public Builder template(Resource template) {
            this.templates.add((Object)Preconditions.checkNotNull(template, "template"));
            return this;
        }

        public Builder templates(Iterable<Resource> templates) {
            this.templates.addAll((Iterable)Preconditions.checkNotNull(templates, "templates"));
            return this;
        }

        public Builder library(Resource library) {
            this.libraries.add((Object)Preconditions.checkNotNull(library, "library"));
            return this;
        }

        public Builder libraries(Iterable<Resource> libraries) {
            this.libraries.addAll((Iterable)Preconditions.checkNotNull(libraries, "libraries"));
            return this;
        }

        public Builder version(String version) {
            this.version = Preconditions.checkNotNull(version, "version");
            return this;
        }

        public Builder recipe(Resource recipe) {
            this.recipes.add((Object)Preconditions.checkNotNull(recipe, "recipe"));
            return this;
        }

        public Builder recipes(Iterable<Resource> recipes) {
            this.recipes.addAll((Iterable)Preconditions.checkNotNull(recipes, "recipes"));
            return this;
        }

        public Builder rootFile(Resource rootFile) {
            this.rootFiles.add((Object)Preconditions.checkNotNull(rootFile, "rootFile"));
            return this;
        }

        public Builder rootFiles(Iterable<Resource> rootFiles) {
            this.rootFiles.addAll((Iterable)Preconditions.checkNotNull(rootFiles, "rootFiles"));
            return this;
        }

        public CookbookVersion build() {
            return new CookbookVersion(Preconditions.checkNotNull(this.cookbookName, "name") + "-" + Preconditions.checkNotNull(this.version, "version"), (Set<Resource>)((Object)this.definitions.build()), (Set<Resource>)((Object)this.attributes.build()), (Set<Resource>)((Object)this.files.build()), this.metadata, (Set<Resource>)((Object)this.providers.build()), this.cookbookName, (Set<Resource>)((Object)this.resources.build()), (Set<Resource>)((Object)this.templates.build()), (Set<Resource>)((Object)this.libraries.build()), this.version, (Set<Resource>)((Object)this.recipes.build()), (Set<Resource>)((Object)this.rootFiles.build()));
        }
    }
}

