/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.config;

import com.google.common.base.Optional;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.config.InstallChef;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.statements.chef.InstallChefGems;
import org.jclouds.scriptbuilder.statements.chef.InstallChefUsingOmnibus;
import org.jclouds.scriptbuilder.statements.ruby.InstallRuby;
import org.jclouds.scriptbuilder.statements.ruby.InstallRubyGems;

public class ChefBootstrapModule
extends AbstractModule {
    @Provides
    @Named(value="installChefGems")
    @Singleton
    final Statement installChefGems(BootstrapProperties bootstrapProperties) {
        InstallRubyGems installRubyGems = InstallRubyGems.builder().version(bootstrapProperties.gemSystemVersion().orNull()).updateSystem(bootstrapProperties.updateGemSystem(), bootstrapProperties.gemSystemVersion().orNull()).updateExistingGems(bootstrapProperties.updateGems()).build();
        InstallChefGems installChef = InstallChefGems.builder().version(bootstrapProperties.chefVersion().orNull()).build();
        return new StatementList(InstallRuby.builder().build(), installRubyGems, installChef);
    }

    @Provides
    @Named(value="installChefOmnibus")
    @Singleton
    final Statement installChefUsingOmnibus(BootstrapProperties bootstrapProperties) {
        return bootstrapProperties.chefVersion().isPresent() ? new InstallChefUsingOmnibus(bootstrapProperties.chefVersion().get()) : new InstallChefUsingOmnibus();
    }

    @Provides
    @InstallChef
    @Singleton
    final Statement installChef(BootstrapProperties bootstrapProperties, @Named(value="installChefGems") Statement installChefGems, @Named(value="installChefOmnibus") Statement installChefOmnibus) {
        return bootstrapProperties.useOmnibus() ? installChefOmnibus : installChefGems;
    }

    @Override
    protected void configure() {
    }

    @Singleton
    private static class BootstrapProperties {
        @Named(value="chef.version")
        @Inject(optional=true)
        private String chefVersionProperty;
        @Named(value="chef.gem-system-version")
        @Inject(optional=true)
        private String gemSystemVersionProperty;
        @Named(value="chef.update-gem-system")
        @Inject
        private String updateGemSystemProeprty;
        @Named(value="chef.update-gems")
        @Inject
        private String updateGemsProperty;
        @Named(value="chef.use-omnibus")
        @Inject
        private String useOmnibus;

        private BootstrapProperties() {
        }

        public Optional<String> chefVersion() {
            return Optional.fromNullable(this.chefVersionProperty);
        }

        public Optional<String> gemSystemVersion() {
            return Optional.fromNullable(this.gemSystemVersionProperty);
        }

        public boolean updateGemSystem() {
            return Boolean.parseBoolean(this.updateGemSystemProeprty);
        }

        public boolean updateGems() {
            return Boolean.parseBoolean(this.updateGemsProperty);
        }

        public boolean useOmnibus() {
            return Boolean.parseBoolean(this.useOmnibus);
        }
    }
}

