/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import org.jclouds.blobstore.domain.BlobAccess;

public class PutOptions
implements Cloneable {
    public static final ImmutablePutOptions NONE = new ImmutablePutOptions(new PutOptions());
    private BlobAccess blobAccess = BlobAccess.PRIVATE;
    private boolean multipart = false;
    private boolean useCustomExecutor = false;
    private ListeningExecutorService customExecutor = MoreExecutors.newDirectExecutorService();

    public PutOptions() {
    }

    public PutOptions(boolean multipart) {
        this.multipart = multipart;
    }

    protected PutOptions(boolean multipart, boolean useCustomExecutor, ListeningExecutorService customExecutor) {
        Preconditions.checkNotNull(customExecutor);
        this.multipart = multipart;
        this.useCustomExecutor = useCustomExecutor;
        this.customExecutor = customExecutor;
    }

    public PutOptions(ListeningExecutorService customExecutor) {
        Preconditions.checkNotNull(customExecutor);
        this.multipart = true;
        this.useCustomExecutor = true;
        this.customExecutor = customExecutor;
    }

    public BlobAccess getBlobAccess() {
        return this.blobAccess;
    }

    public boolean getUseCustomExecutor() {
        return this.useCustomExecutor;
    }

    public ListeningExecutorService getCustomExecutor() {
        return this.customExecutor;
    }

    public PutOptions setCustomExecutor(ListeningExecutorService customExecutor) {
        Preconditions.checkNotNull(customExecutor);
        this.multipart = true;
        this.useCustomExecutor = true;
        this.customExecutor = customExecutor;
        return this;
    }

    public PutOptions setBlobAccess(BlobAccess blobAccess) {
        this.blobAccess = Preconditions.checkNotNull(blobAccess);
        return this;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public PutOptions multipart() {
        return this.multipart(true);
    }

    public PutOptions multipart(boolean val) {
        this.multipart = val;
        return this;
    }

    public PutOptions multipart(ListeningExecutorService customExecutor) {
        Preconditions.checkNotNull(customExecutor);
        this.multipart = true;
        this.useCustomExecutor = true;
        this.customExecutor = customExecutor;
        return this;
    }

    public PutOptions clone() {
        return new PutOptions(this.multipart, this.useCustomExecutor, this.customExecutor);
    }

    public String toString() {
        return "[multipart=" + this.multipart + ", blobAccess=" + (Object)((Object)this.blobAccess) + ", useCustomExecutor=" + this.useCustomExecutor + ", customExecutor=" + this.customExecutor + "]";
    }

    public static class Builder {
        public static PutOptions fromPutOptions(PutOptions putOptions) {
            return Builder.multipart(putOptions.multipart);
        }

        public static PutOptions multipart() {
            return Builder.multipart(true);
        }

        public static PutOptions multipart(boolean val) {
            PutOptions options = new PutOptions();
            return options.multipart(val);
        }

        public static PutOptions multipart(ListeningExecutorService customExecutor) {
            PutOptions options = new PutOptions();
            return options.multipart(customExecutor);
        }
    }

    public static class ImmutablePutOptions
    extends PutOptions {
        private final PutOptions delegate;

        public ImmutablePutOptions(PutOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public ListeningExecutorService getCustomExecutor() {
            return this.delegate.getCustomExecutor();
        }

        @Override
        public PutOptions setCustomExecutor(ListeningExecutorService customExecutor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlobAccess getBlobAccess() {
            return this.delegate.getBlobAccess();
        }

        @Override
        public PutOptions setBlobAccess(BlobAccess blobAccess) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMultipart() {
            return this.delegate.isMultipart();
        }

        @Override
        public PutOptions multipart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PutOptions clone() {
            return this.delegate.clone();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

