/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.List;
import org.jclouds.azurecompute.arm.domain.ResourceProviderMetaData;

final class AutoValue_ResourceProviderMetaData
extends ResourceProviderMetaData {
    private final String resourceType;
    private final List<String> locations;
    private final List<String> apiVersions;

    private AutoValue_ResourceProviderMetaData(String resourceType, List<String> locations, List<String> apiVersions) {
        this.resourceType = resourceType;
        this.locations = locations;
        this.apiVersions = apiVersions;
    }

    @Override
    public String resourceType() {
        return this.resourceType;
    }

    @Override
    public List<String> locations() {
        return this.locations;
    }

    @Override
    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public String toString() {
        return "ResourceProviderMetaData{resourceType=" + this.resourceType + ", locations=" + this.locations + ", apiVersions=" + this.apiVersions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResourceProviderMetaData) {
            ResourceProviderMetaData that = (ResourceProviderMetaData)o;
            return this.resourceType.equals(that.resourceType()) && this.locations.equals(that.locations()) && this.apiVersions.equals(that.apiVersions());
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.resourceType.hashCode();
        h2 *= 1000003;
        h2 ^= this.locations.hashCode();
        h2 *= 1000003;
        return h2 ^= this.apiVersions.hashCode();
    }

    @Override
    public ResourceProviderMetaData.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ResourceProviderMetaData.Builder {
        private String resourceType;
        private List<String> locations;
        private List<String> apiVersions;

        Builder() {
        }

        private Builder(ResourceProviderMetaData source) {
            this.resourceType = source.resourceType();
            this.locations = source.locations();
            this.apiVersions = source.apiVersions();
        }

        @Override
        public ResourceProviderMetaData.Builder resourceType(String resourceType) {
            if (resourceType == null) {
                throw new NullPointerException("Null resourceType");
            }
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public ResourceProviderMetaData.Builder locations(List<String> locations) {
            if (locations == null) {
                throw new NullPointerException("Null locations");
            }
            this.locations = locations;
            return this;
        }

        @Override
        List<String> locations() {
            if (this.locations == null) {
                throw new IllegalStateException("Property \"locations\" has not been set");
            }
            return this.locations;
        }

        @Override
        public ResourceProviderMetaData.Builder apiVersions(List<String> apiVersions) {
            if (apiVersions == null) {
                throw new NullPointerException("Null apiVersions");
            }
            this.apiVersions = apiVersions;
            return this;
        }

        @Override
        List<String> apiVersions() {
            if (this.apiVersions == null) {
                throw new IllegalStateException("Property \"apiVersions\" has not been set");
            }
            return this.apiVersions;
        }

        @Override
        ResourceProviderMetaData autoBuild() {
            String missing = "";
            if (this.resourceType == null) {
                missing = missing + " resourceType";
            }
            if (this.locations == null) {
                missing = missing + " locations";
            }
            if (this.apiVersions == null) {
                missing = missing + " apiVersions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ResourceProviderMetaData(this.resourceType, this.locations, this.apiVersions);
        }
    }
}

