/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.jclouds.azurecompute.arm.compute.domain.AutoValue_ResourceGroupAndName;

public abstract class ResourceGroupAndName {
    public abstract String resourceGroup();

    public abstract String name();

    protected ResourceGroupAndName() {
    }

    public static ResourceGroupAndName fromSlashEncoded(String id) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(id, "id"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "id must be in format resourcegroup/name");
        return new AutoValue_ResourceGroupAndName(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static ResourceGroupAndName fromResourceGroupAndName(String resourceGroup, String name) {
        return new AutoValue_ResourceGroupAndName(resourceGroup, name);
    }

    public String slashEncode() {
        return this.resourceGroup() + "/" + this.name();
    }
}

