/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.jclouds.azurecompute.arm.compute.domain.AutoValue_LocationAndName;

public abstract class LocationAndName {
    public abstract String location();

    public abstract String name();

    protected LocationAndName() {
    }

    public static LocationAndName fromSlashEncoded(String id) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(id, "id"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "id must be in format location/name");
        return new AutoValue_LocationAndName(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static LocationAndName fromLocationAndName(String location, String name) {
        return new AutoValue_LocationAndName(location, name);
    }

    public String slashEncode() {
        return this.location() + "/" + this.name();
    }
}

