/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class DescribeSpotPriceHistoryOptions
extends BaseEC2RequestOptions {
    public static final DescribeSpotPriceHistoryOptions NONE = new DescribeSpotPriceHistoryOptions();
    private static final DateService service = new SimpleDateFormatDateService();

    public DescribeSpotPriceHistoryOptions from(Date start) {
        this.formParameters.put("StartTime", service.iso8601DateFormat(Preconditions.checkNotNull(start, "start")));
        return this;
    }

    public DescribeSpotPriceHistoryOptions to(Date end) {
        this.formParameters.put("EndTime", service.iso8601DateFormat(Preconditions.checkNotNull(end, "end")));
        return this;
    }

    public DescribeSpotPriceHistoryOptions instanceType(String type) {
        this.formParameters.put("InstanceType.1", Preconditions.checkNotNull(type, "type"));
        return this;
    }

    public DescribeSpotPriceHistoryOptions productDescription(String description) {
        this.formParameters.put("ProductDescription", Preconditions.checkNotNull(description, "description"));
        return this;
    }

    public static class Builder {
        public static DescribeSpotPriceHistoryOptions from(Date start) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.from(start);
        }

        public static DescribeSpotPriceHistoryOptions to(Date end) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.to(end);
        }

        public static DescribeSpotPriceHistoryOptions instanceType(String instanceType) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.instanceType(instanceType);
        }

        public static DescribeSpotPriceHistoryOptions productDescription(String description) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.productDescription(description);
        }
    }
}

